/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.math.Vec;
import de.cinderella.modes.Mode;
import de.cinderella.ports.GenericListener;
import de.cinderella.ports.TextPort;
import de.cinderella.ports.ViewPort;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TextPortListener
extends GenericListener
implements MouseListener,
MouseMotionListener {
    public Vec pos = new Vec();
    public transient Cindy kernel;
    public int xpos;
    public int ypos;
    public int yoff;
    public int xold;
    public int type;

    public TextPortListener(Cindy cindy) {
        new Point(0, 0);
        this.kernel = cindy;
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        if (this.type == 5 || this.type == 6 || this.type == 7) {
            return;
        }
        ViewPort viewPort = (ViewPort)mouseEvent.getSource();
        viewPort.toVecGrid(mouseEvent.getPoint(), this.pos);
        Mode mode = (Mode)this.kernel.f20.value;
        if (!viewPort.polar || mode.allowsPolar) {
            mode.mouseClicked(mouseEvent, this.pos, viewPort, this.kernel);
        }
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        TextPort textPort = (TextPort)mouseEvent.getSource();
        this.xpos = mouseEvent.getX();
        this.ypos = mouseEvent.getY();
        int cfr_ignored_0 = textPort.xoff;
        this.yoff = textPort.yoff;
        this.type = 0;
        if (this.xpos > textPort.width - 10 && this.xpos < textPort.width && this.ypos > textPort.slitop && this.ypos < textPort.slibot) {
            this.type = 5;
        }
        if (this.xpos > textPort.width - 10 && this.xpos < textPort.width && this.ypos < textPort.slitop) {
            this.type = 7;
        }
        if (this.xpos > textPort.width - 10 && this.xpos < textPort.width && this.ypos > textPort.slibot) {
            this.type = 6;
        }
        if (this.xpos < textPort.posCoord + 3 && this.xpos > textPort.posCoord - 3) {
            this.type = 4;
        }
        if (this.xpos < textPort.posAlg + 3 && this.xpos > textPort.posAlg - 3) {
            this.type = 3;
        }
        switch (this.type) {
            case 2: {
                this.xold = textPort.bStart;
                break;
            }
            case 4: {
                this.xold = textPort.bAlg;
                break;
            }
            case 3: {
                this.xold = textPort.bLabel;
                break;
            }
        }
        if (this.type == 5 || this.type == 6 || this.type == 7) {
            this.mouseDragged(mouseEvent);
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        TextPort textPort = (TextPort)mouseEvent.getSource();
        switch (this.type) {
            case 2: {
                int n = this.xold + (mouseEvent.getX() - this.xpos);
                textPort.bStart = n < 5 ? 5 : n;
                break;
            }
            case 4: {
                int n = this.xold + (mouseEvent.getX() - this.xpos);
                textPort.bAlg = n < 5 ? 5 : n;
                break;
            }
            case 3: {
                int n = this.xold + (mouseEvent.getX() - this.xpos);
                textPort.bLabel = n < 5 ? 5 : n;
                break;
            }
            case 5: {
                int n = this.yoff - (int)((double)(mouseEvent.getY() - this.ypos) / textPort.slifact);
                if (n + textPort.all < textPort.height - 4) {
                    n = textPort.height - 4 - textPort.all;
                }
                textPort.yoff = n > textPort.head ? textPort.head : n;
                break;
            }
            case 7: {
                int n = this.yoff - (int)((double)(textPort.slitop - textPort.slibot) / textPort.slifact);
                if (n + textPort.all < textPort.height - 4) {
                    n = textPort.height - 4 - textPort.all;
                }
                textPort.yoff = n > textPort.head ? textPort.head : n;
                break;
            }
            case 6: {
                int n = this.yoff - (int)((double)(-textPort.slitop + textPort.slibot) / textPort.slifact);
                if (n + textPort.all < textPort.height - 4) {
                    n = textPort.height - 4 - textPort.all;
                }
                textPort.yoff = n > textPort.head ? textPort.head : n;
                break;
            }
        }
        textPort.repaint();
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
    }
}

