/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.controls.ObservableBool;
import de.cinderella.geometry.Geometry;
import de.cinderella.geometry.Hyperbolic;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.geometry.PGText;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Vec;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Observer;

public class EuclideanPort
extends ViewPort
implements ComponentListener,
Observer {
    public double f39 = 25.0;
    public Point f328 = new Point(100, 300);
    public Point f329 = new Point(100, 300);
    public double f119 = 0.01;
    public int f330;
    public Vec f331 = new Vec();
    public ObservableBool f332 = new ObservableBool("mesh", false);
    public ObservableBool f333 = new ObservableBool("axes", false);
    public ObservableBool f334 = new ObservableBool("snap", false);
    public Vec f335 = new Vec();
    public Vec f336 = new Vec();
    public Vec f337 = new Vec();
    public Vec f338 = new Vec();
    public Vec f339 = new Vec();
    public Vec f340 = new Vec();
    public Vec f341 = new Vec();
    public Vec f342 = new Vec();
    public int f343 = 3;
    public String f7;
    public Point f86 = new Point();
    public DoublePoint f80 = new DoublePoint();
    public DoublePoint f81 = new DoublePoint();
    public Vec f110 = new Vec();
    public Vec f111 = new Vec();

    public EuclideanPort() {
        this.f332.addObserver(this);
        this.f333.addObserver(this);
        this.f334.addObserver(this);
        c125 c1252 = new c125(this.f334);
        c1252.m96(this.f334, true, this.f333, false, this.f332, true);
        c1252.m96(this.f334, true, this.f332, false, this.f333, true);
        c1252 = new c125(this.f332);
        c1252.m96(this.f332, false, this.f333, false, this.f334, false);
        c1252 = new c125(this.f333);
        c1252.m96(this.f332, false, this.f333, false, this.f334, false);
        Dimension dimension = this.pref;
        this.width = dimension.width;
        this.height = dimension.height;
        this.reset();
    }

    public final ViewPortElement fittingPGElement(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            if (this.polar) {
                return new c120(pGElement, this);
            }
            return new c118(pGElement, this);
        }
        if (pGElement instanceof PGLine) {
            if (this.polar) {
                return new c118(pGElement, this);
            }
            return new c120(pGElement, this);
        }
        if (pGElement instanceof PGSegment) {
            if (this.polar) {
                return new c118(pGElement, this);
            }
            return new c120(pGElement, this);
        }
        if (pGElement instanceof PGLocus) {
            return new c116(pGElement, this);
        }
        if (pGElement instanceof PGText) {
            if (this.polar) {
                return null;
            }
            return new c117(pGElement, this);
        }
        if (pGElement instanceof PGConic) {
            return new c119(pGElement, this);
        }
        if (pGElement instanceof PGPolygon) {
            if (this.polar) {
                return null;
            }
            return new c115(pGElement, this);
        }
        return null;
    }

    public final void toVec(Point point, Vec vec) {
        this.toVec(point.x, point.y, vec);
    }

    public final void toVec(int n, int n2, Vec vec) {
        vec.assign((double)(n - this.f328.x) / this.f39, (double)(n2 - this.f328.y) / this.f39, 1.0);
    }

    public final void m81(double d, double d2, Vec vec) {
        vec.assign((d - (double)this.f328.x) / this.f39, (d2 - (double)this.f328.y) / this.f39, 1.0);
    }

    public final void toVecGrid(Point point, Vec vec) {
        vec.assign((double)(point.x - this.f328.x) / this.f39, (double)(point.y - this.f328.y) / this.f39, 1.0);
        if (this.f334.value && this.f332.value) {
            this.f331.assign((double)Math.round(vec.xr / this.f119) * this.f119, (double)Math.round(vec.yr / this.f119) * this.f119, 1.0);
            double d = this.f331.xr - vec.xr;
            double d2 = this.f331.yr - vec.yr;
            if (d * d + d2 * d2 < this.f119 * this.f119 / 30.0) {
                vec.assign(this.f331);
            }
        }
    }

    public final boolean toPoint(Vec vec, Point point) {
        double d;
        double d2;
        if (vec.zr == 0.0 && vec.zi == 0.0) {
            return false;
        }
        if (vec.zi == 0.0) {
            d2 = vec.xr / vec.zr;
            d = vec.yr / vec.zr;
        } else {
            double d3 = vec.zr * vec.zr + vec.zi * vec.zi;
            d2 = (vec.xr * vec.zr + vec.xi * vec.zi) / d3;
            d = (vec.yr * vec.zr + vec.yi * vec.zi) / d3;
        }
        point.move((int)(d2 * this.f39 + (double)this.f328.x), (int)(d * this.f39 + (double)this.f328.y));
        return true;
    }

    public final boolean toPoint(Vec vec, DoublePoint doublePoint) {
        double d;
        double d2;
        if (vec.zr == 0.0 && vec.zi == 0.0) {
            return false;
        }
        if (vec.zi == 0.0) {
            d2 = vec.xr / vec.zr;
            d = vec.yr / vec.zr;
        } else {
            double d3 = vec.zr * vec.zr + vec.zi * vec.zi;
            d2 = (vec.xr * vec.zr + vec.xi * vec.zi) / d3;
            d = (vec.yr * vec.zr + vec.yi * vec.zi) / d3;
        }
        doublePoint.x = d2 * this.f39 + (double)this.f328.x;
        doublePoint.y = d * this.f39 + (double)this.f328.y;
        return true;
    }

    public final void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.width > 0 && this.height > 0) {
            this.m83();
        }
    }

    public final void m82() {
        Point point = new Point(-1, -1);
        Point point2 = new Point(-1, this.height + 1);
        Point point3 = new Point(this.width + 1, -1);
        Point point4 = new Point(this.width + 1, this.height + 1);
        Vec vec = new Vec(0.0, 0.0, 0.0);
        Vec vec2 = new Vec(0.0, 0.0, 0.0);
        Vec vec3 = new Vec(0.0, 0.0, 0.0);
        Vec vec4 = new Vec(0.0, 0.0, 0.0);
        this.toVec(point, vec);
        this.toVec(point2, vec2);
        this.toVec(point3, vec3);
        this.toVec(point4, vec4);
        Vec vec5 = new Vec(0.0, 0.0, 0.0);
        vec5.cross(vec, vec2);
        this.f335.assign(vec5);
        vec5.cross(vec2, vec4);
        this.f338.assign(vec5);
        vec5.cross(vec4, vec3);
        this.f337.assign(vec5);
        vec5.cross(vec3, vec);
        this.f336.assign(vec5);
        point.setLocation(this.f343, this.f343);
        point2.setLocation(this.f343, this.height - this.f343);
        point3.setLocation(this.width - this.f343, this.f343);
        point4.setLocation(this.width - this.f343, this.height - this.f343);
        this.toVec(point, vec);
        this.toVec(point2, vec2);
        this.toVec(point3, vec3);
        this.toVec(point4, vec4);
        vec5.cross(vec, vec2);
        this.f339.assign(vec5);
        vec5.cross(vec2, vec4);
        this.f342.assign(vec5);
        vec5.cross(vec4, vec3);
        this.f341.assign(vec5);
        vec5.cross(vec3, vec);
        this.f340.assign(vec5);
        this.elements.resize(this.width, this.height);
        this.elements.forceRecalc();
    }

    public final void m83() {
        this.m82();
        this.m85();
        this.repaint();
    }

    public final void setKernel(Cindy cindy) {
        super.setKernel(cindy);
        cindy.f16.addObserver(this);
    }

    public final void m84(int n, int n2, double d) {
        this.f39 = d;
        this.f328.move(n, n2);
        this.f329.move(n, n2);
        this.m85();
    }

    public final void m85() {
        double d = 50.0 / this.f39;
        double d2 = Math.floor(Math.log(d) / Math.log(10.0));
        double d3 = 1.0;
        double[] dArray = new double[]{0.25, 0.5, 1.0, 2.5, 5.0, 10.0, 25.0, 50.0};
        int n = 4;
        if (this.f330 < -2) {
            this.f330 = -2;
        }
        if (this.f330 > 2) {
            this.f330 = 2;
        }
        if (d2 < 0.0) {
            while (d2 < 0.0) {
                d3 /= 10.0;
                d2 += 1.0;
            }
        } else if (d2 > 0.0) {
            while (d2 > 0.0) {
                d3 *= 10.0;
                d2 -= 1.0;
            }
        }
        n = d > 10.0 * d3 * 0.8 ? 5 : (d > 5.0 * d3 * 0.8 ? 4 : (d > 2.5 * d3 * 0.8 ? 3 : 2));
        this.f119 = d3 * dArray[n -= this.f330];
    }

    public final void m86(Graphics graphics, int n, int n2, int n3, double d) {
        if (this.width - n - n3 < 7) {
            n -= n3;
        }
        if (this.height - n2 < 7) {
            n2 -= n3;
        }
        graphics.setColor(this.lineCT.black.level[4]);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
        graphics.drawLine(n, n2 - 1, n + n3, n2 - 1);
        graphics.drawLine(n, n2 - 3, n, n2 + 3);
        graphics.drawLine(n + n3, n2 - 3, n + n3, n2 + 3);
        this.f7 = String.valueOf(d);
        graphics.drawString(this.f7, n + 5, n2 - 3);
    }

    public final void m87(Graphics graphics) {
        this.f110.assign(0.0, 0.0, 1.0);
        this.toPoint(this.f110, this.f86);
        graphics.setColor(this.lineCT.black.level[2]);
        graphics.drawLine(this.f86.x, 0, this.f86.x, this.height);
        graphics.drawLine(this.f86.x - 1, 0, this.f86.x - 1, this.height);
        graphics.drawLine(this.f86.x + 1, 0, this.f86.x + 1, this.height);
        graphics.drawLine(0, this.f86.y, this.width, this.f86.y);
        graphics.drawLine(0, this.f86.y - 1, this.width, this.f86.y - 1);
        graphics.drawLine(0, this.f86.y + 1, this.width, this.f86.y + 1);
    }

    public final void m88(Graphics graphics, boolean bl) {
        this.f110.assign(0.0, 0.0, 1.0);
        this.toPoint(this.f110, this.f80);
        this.f110.assign(1.0, 0.0, 1.0);
        this.toPoint(this.f110, this.f81);
        double d = this.f81.x - this.f80.x;
        graphics.setColor(this.lineCT.black.level[2]);
        graphics.drawOval((int)(this.f80.x - d), (int)(this.f80.y - d + 1.0), (int)(2.0 * d), (int)(2.0 * d));
        if (bl) {
            graphics.drawOval((int)(this.f80.x - d + 1.0), (int)(this.f80.y - d), (int)(2.0 * d), (int)(2.0 * d));
            graphics.drawOval((int)(this.f80.x - d - 1.0), (int)(this.f80.y - d), (int)(2.0 * d), (int)(2.0 * d));
            graphics.drawOval((int)(this.f80.x - d), (int)(this.f80.y - d), (int)(2.0 * d), (int)(2.0 * d));
            graphics.drawOval((int)(this.f80.x - d), (int)(this.f80.y - d + 2.0), (int)(2.0 * d), (int)(2.0 * d));
        }
    }

    public final void paintMesh(Graphics graphics) {
        if (this.kernel.f16.value == Geometry.hyperbolic) {
            this.m88(graphics, false);
        }
        if (this.f332.value || this.f333.value) {
            double d;
            double d2;
            int n = this.width;
            int n2 = this.height;
            this.f110.assign(0.0, 0.0, 1.0);
            this.f111.assign(this.f119, 0.0, 1.0);
            this.toPoint(this.f110, this.f80);
            this.toPoint(this.f110, this.f86);
            this.toPoint(this.f111, this.f81);
            double d3 = this.f81.x - this.f80.x;
            this.toVec(0, 0, this.f110);
            this.f110.normalizeZ();
            this.f110.xr = Math.floor(this.f110.xr / this.f119) * this.f119;
            this.f110.yr = Math.floor(this.f110.yr / this.f119) * this.f119;
            this.toPoint(this.f110, this.f80);
            graphics.setColor(this.lineCT.black.level[1]);
            if (this.f332.value) {
                d2 = this.f80.x;
                while (d2 < (double)n) {
                    graphics.drawLine((int)d2, 0, (int)d2, n2);
                    d2 += d3;
                }
                d = this.f80.y;
                while (d < (double)n2) {
                    graphics.drawLine(0, (int)d, n, (int)d);
                    d += d3;
                }
            } else {
                int n3 = this.f86.x - 4;
                int n4 = this.f86.x + 4;
                int n5 = this.f86.y - 4;
                int n6 = this.f86.y + 4;
                d2 = this.f80.x;
                while (d2 < (double)n) {
                    graphics.drawLine((int)d2, n5, (int)d2, n6);
                    d2 += d3;
                }
                d = this.f80.y;
                while (d < (double)n2) {
                    graphics.drawLine(n3, (int)d, n4, (int)d);
                    d += d3;
                }
            }
            if (this.f333.value) {
                d -= d3;
                d2 -= 2.0 * d3;
                if (!this.f332.value) {
                    d = n2 - 10;
                    d2 = (double)(n - 10) - d3;
                }
                this.m87(graphics);
                this.m86(graphics, (int)d2, (int)d, (int)d3, this.f119);
            }
            if (this.kernel.f16.value instanceof Hyperbolic) {
                this.m88(graphics, true);
            }
        }
    }

    public final void initFromHTML(Applet applet) {
        super.initFromHTML(applet);
        this.f334.setValue(applet.getParameter("snap").equals("true"));
        this.f332.setValue(applet.getParameter("mesh").equals("true"));
        this.f333.setValue(applet.getParameter("axes").equals("true"));
        try {
            this.m84(new Integer(applet.getParameter("originx")), new Integer(applet.getParameter("originy")), new Double(applet.getParameter("scale")));
            this.f330 = new Integer(applet.getParameter("deltafactor"));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void reset() {
        super.reset();
        this.f39 = 25.0;
        this.f328.x = this.width / 3;
        this.f328.y = this.height * 2 / 3;
        this.m85();
        this.m83();
        this.repaint();
    }

    public final void softReset() {
        super.softReset();
        this.f39 = 25.0;
        this.f328.x = this.width / 3;
        this.f328.y = this.height * 2 / 3;
        this.m85();
        this.m83();
        this.repaint();
    }
}

