/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.math;

import de.cinderella.geometry.Restorer;
import de.cinderella.math.Assignable;
import de.cinderella.math.Complex;
import de.cinderella.math.Tracable;
import de.cinderella.math.Vec;
import java.io.Serializable;

public final class Mat
implements Serializable,
Tracable,
Assignable,
Restorer {
    public double axr;
    public double axi;
    public double ayr;
    public double ayi;
    public double azr;
    public double azi;
    public double bxr;
    public double bxi;
    public double byr;
    public double byi;
    public double bzr;
    public double bzi;
    public double cxr;
    public double cxi;
    public double cyr;
    public double cyi;
    public double czr;
    public double czi;
    public int invalid;
    public static final Mat idneg;
    public static final Complex ct;
    public static final Vec p;
    public static final Mat l;
    public static Mat lCL;
    public static Mat sCL;
    public static Vec lineCiCi;
    public static Vec line1CiCi;
    public static final Vec CCsol;
    public static final Vec CCl12;
    public static final Vec CCl11;
    public static final Vec CCl21;
    public static final Vec CCl22;
    public static final Complex CCa;
    public static final Complex CCb;
    public static final Complex CCc;
    public static final Complex CCd;
    public static final Complex CClambda;
    public static final Mat CCdeg;
    public static final Vec EVsol;
    public static final Complex EVb;
    public static Complex ran1;
    public static Complex ran2;
    public static Complex ran3;
    public static Vec ranv;

    public Mat() {
    }

    public Mat(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.axr = d;
        this.bxr = d2;
        this.cxr = d3;
        this.ayr = d4;
        this.byr = d5;
        this.cyr = d6;
        this.azr = d7;
        this.bzr = d8;
        this.czr = d9;
        this.invalid = 0;
    }

    public Mat(Complex complex, Complex complex2, Complex complex3, Complex complex4, Complex complex5, Complex complex6, Complex complex7, Complex complex8, Complex complex9) {
        this.axr = complex.real;
        this.bxr = complex2.real;
        this.cxr = complex3.real;
        this.ayr = complex4.real;
        this.byr = complex5.real;
        this.cyr = complex6.real;
        this.azr = complex7.real;
        this.bzr = complex8.real;
        this.czr = complex9.real;
        this.axi = complex.imag;
        this.bxi = complex2.imag;
        this.cxi = complex3.imag;
        this.ayi = complex4.imag;
        this.byi = complex5.imag;
        this.cyi = complex6.imag;
        this.azi = complex7.imag;
        this.bzi = complex8.imag;
        this.czi = complex9.imag;
        this.invalid = 0;
    }

    public Mat(double d, double d2, double d3, double d4, double d5, double d6) {
        this.axr = d;
        this.ayr = this.bxr = d4 / 2.0;
        this.byr = d2;
        this.cxr = this.azr = d5 / 2.0;
        this.bzr = this.cyr = d6 / 2.0;
        this.czr = d3;
        this.invalid = 0;
    }

    public Mat(Mat mat) {
        this.assign(mat);
    }

    public final void assign(Assignable assignable) {
        this.assign((Mat)assignable);
    }

    public final Mat setInvalide() {
        this.axr = 0.0;
        this.bxr = 0.0;
        this.cxr = 0.0;
        this.ayr = 0.0;
        this.byr = 0.0;
        this.cyr = 0.0;
        this.azr = 0.0;
        this.bzr = 0.0;
        this.czr = 0.0;
        this.axi = 0.0;
        this.bxi = 0.0;
        this.cxi = 0.0;
        this.ayi = 0.0;
        this.byi = 0.0;
        this.cyi = 0.0;
        this.azi = 0.0;
        this.bzi = 0.0;
        this.czi = 0.0;
        this.invalid = 1;
        return this;
    }

    public final Mat assign(Mat mat) {
        this.axr = mat.axr;
        this.bxr = mat.bxr;
        this.cxr = mat.cxr;
        this.ayr = mat.ayr;
        this.byr = mat.byr;
        this.cyr = mat.cyr;
        this.azr = mat.azr;
        this.bzr = mat.bzr;
        this.czr = mat.czr;
        this.axi = mat.axi;
        this.bxi = mat.bxi;
        this.cxi = mat.cxi;
        this.ayi = mat.ayi;
        this.byi = mat.byi;
        this.cyi = mat.cyi;
        this.azi = mat.azi;
        this.bzi = mat.bzi;
        this.czi = mat.czi;
        this.invalid = mat.invalid;
        return this;
    }

    public final boolean equals(Mat mat) {
        return this.axr == mat.axr && this.bxr == mat.bxr && this.cxr == mat.cxr && this.ayr == mat.ayr && this.byr == mat.byr && this.cyr == mat.cyr && this.azr == mat.azr && this.bzr == mat.bzr && this.czr == mat.czr && this.axi == mat.axi && this.bxi == mat.bxi && this.cxi == mat.cxi && this.ayi == mat.ayi && this.byi == mat.byi && this.cyi == mat.cyi && this.azi == mat.azi && this.bzi == mat.bzi && this.czi == mat.czi && this.invalid == mat.invalid;
    }

    public final Object clone() {
        return new Mat(this);
    }

    public final boolean resembles(Object object) {
        return this.equals((Mat)object);
    }

    public final void restore(Object object) {
        ((Mat)object).assign(this);
    }

    public final void save(Object object) {
        this.assign((Mat)object);
    }

    public final Mat mul(Mat mat) {
        double d = this.axr * mat.axr + this.bxr * mat.ayr + this.cxr * mat.azr - this.axi * mat.axi - this.bxi * mat.ayi - this.cxi * mat.azi;
        double d2 = this.axr * mat.axi + this.bxr * mat.ayi + this.cxr * mat.azi + this.axi * mat.axr + this.bxi * mat.ayr + this.cxi * mat.azr;
        double d3 = this.ayr * mat.axr + this.byr * mat.ayr + this.cyr * mat.azr - this.ayi * mat.axi - this.byi * mat.ayi - this.cyi * mat.azi;
        double d4 = this.ayr * mat.axi + this.byr * mat.ayi + this.cyr * mat.azi + this.ayi * mat.axr + this.byi * mat.ayr + this.cyi * mat.azr;
        double d5 = this.azr * mat.axr + this.bzr * mat.ayr + this.czr * mat.azr - this.azi * mat.axi - this.bzi * mat.ayi - this.czi * mat.azi;
        double d6 = this.azr * mat.axi + this.bzr * mat.ayi + this.czr * mat.azi + this.azi * mat.axr + this.bzi * mat.ayr + this.czi * mat.azr;
        double d7 = this.axr * mat.bxr + this.bxr * mat.byr + this.cxr * mat.bzr - this.axi * mat.bxi - this.bxi * mat.byi - this.cxi * mat.bzi;
        double d8 = this.axr * mat.bxi + this.bxr * mat.byi + this.cxr * mat.bzi + this.axi * mat.bxr + this.bxi * mat.byr + this.cxi * mat.bzr;
        double d9 = this.ayr * mat.bxr + this.byr * mat.byr + this.cyr * mat.bzr - this.ayi * mat.bxi - this.byi * mat.byi - this.cyi * mat.bzi;
        double d10 = this.ayr * mat.bxi + this.byr * mat.byi + this.cyr * mat.bzi + this.ayi * mat.bxr + this.byi * mat.byr + this.cyi * mat.bzr;
        double d11 = this.azr * mat.bxr + this.bzr * mat.byr + this.czr * mat.bzr - this.azi * mat.bxi - this.bzi * mat.byi - this.czi * mat.bzi;
        double d12 = this.azr * mat.bxi + this.bzr * mat.byi + this.czr * mat.bzi + this.azi * mat.bxr + this.bzi * mat.byr + this.czi * mat.bzr;
        double d13 = this.axr * mat.cxr + this.bxr * mat.cyr + this.cxr * mat.czr - this.axi * mat.cxi - this.bxi * mat.cyi - this.cxi * mat.czi;
        double d14 = this.axr * mat.cxi + this.bxr * mat.cyi + this.cxr * mat.czi + this.axi * mat.cxr + this.bxi * mat.cyr + this.cxi * mat.czr;
        double d15 = this.ayr * mat.cxr + this.byr * mat.cyr + this.cyr * mat.czr - this.ayi * mat.cxi - this.byi * mat.cyi - this.cyi * mat.czi;
        double d16 = this.ayr * mat.cxi + this.byr * mat.cyi + this.cyr * mat.czi + this.ayi * mat.cxr + this.byi * mat.cyr + this.cyi * mat.czr;
        double d17 = this.azr * mat.cxr + this.bzr * mat.cyr + this.czr * mat.czr - this.azi * mat.cxi - this.bzi * mat.cyi - this.czi * mat.czi;
        double d18 = this.azr * mat.cxi + this.bzr * mat.cyi + this.czr * mat.czi + this.azi * mat.cxr + this.bzi * mat.cyr + this.czi * mat.czr;
        this.axr = d;
        this.bxr = d7;
        this.cxr = d13;
        this.ayr = d3;
        this.byr = d9;
        this.cyr = d15;
        this.azr = d5;
        this.bzr = d11;
        this.czr = d17;
        this.axi = d2;
        this.bxi = d8;
        this.cxi = d14;
        this.ayi = d4;
        this.byi = d10;
        this.cyi = d16;
        this.azi = d6;
        this.bzi = d12;
        this.czi = d18;
        return this;
    }

    public final Mat degConic(Vec vec, Vec vec2) {
        this.axr = vec.xr * vec2.xr - vec.xi * vec2.xi;
        this.ayr = vec.yr * vec2.xr - vec.yi * vec2.xi;
        this.azr = vec.zr * vec2.xr - vec.zi * vec2.xi;
        this.bxr = vec.xr * vec2.yr - vec.xi * vec2.yi;
        this.byr = vec.yr * vec2.yr - vec.yi * vec2.yi;
        this.bzr = vec.zr * vec2.yr - vec.zi * vec2.yi;
        this.cxr = vec.xr * vec2.zr - vec.xi * vec2.zi;
        this.cyr = vec.yr * vec2.zr - vec.yi * vec2.zi;
        this.czr = vec.zr * vec2.zr - vec.zi * vec2.zi;
        this.axi = vec.xr * vec2.xi + vec.xi * vec2.xr;
        this.ayi = vec.yr * vec2.xi + vec.yi * vec2.xr;
        this.azi = vec.zr * vec2.xi + vec.zi * vec2.xr;
        this.bxi = vec.xr * vec2.yi + vec.xi * vec2.yr;
        this.byi = vec.yr * vec2.yi + vec.yi * vec2.yr;
        this.bzi = vec.zr * vec2.yi + vec.zi * vec2.yr;
        this.cxi = vec.xr * vec2.zi + vec.xi * vec2.zr;
        this.cyi = vec.yr * vec2.zi + vec.yi * vec2.zr;
        this.czi = vec.zr * vec2.zi + vec.zi * vec2.zr;
        return this;
    }

    public final Mat t() {
        double d = this.ayr;
        this.ayr = this.bxr;
        this.bxr = d;
        d = this.azr;
        this.azr = this.cxr;
        this.cxr = d;
        d = this.bzr;
        this.bzr = this.cyr;
        this.cyr = d;
        d = this.ayi;
        this.ayi = this.bxi;
        this.bxi = d;
        d = this.azi;
        this.azi = this.cxi;
        this.cxi = d;
        d = this.bzi;
        this.bzi = this.cyi;
        this.cyi = d;
        return this;
    }

    public final Mat add(Mat mat) {
        this.axr += mat.axr;
        this.bxr += mat.bxr;
        this.cxr += mat.cxr;
        this.ayr += mat.ayr;
        this.byr += mat.byr;
        this.cyr += mat.cyr;
        this.azr += mat.azr;
        this.bzr += mat.bzr;
        this.czr += mat.czr;
        this.axi += mat.axi;
        this.bxi += mat.bxi;
        this.cxi += mat.cxi;
        this.ayi += mat.ayi;
        this.byi += mat.byi;
        this.cyi += mat.cyi;
        this.azi += mat.azi;
        this.bzi += mat.bzi;
        this.czi += mat.czi;
        return this;
    }

    public final Mat subDiag(Complex complex) {
        this.axr -= complex.real;
        this.byr -= complex.real;
        this.czr -= complex.real;
        this.axi -= complex.imag;
        this.byi -= complex.imag;
        this.czi -= complex.imag;
        return this;
    }

    public final Mat symm() {
        this.axr += this.axr;
        this.byr += this.byr;
        this.czr += this.czr;
        this.axi += this.axi;
        this.byi += this.byi;
        this.czi += this.czi;
        this.bxr += this.ayr;
        this.ayr = this.bxr;
        this.cxr += this.azr;
        this.azr = this.cxr;
        this.cyr += this.bzr;
        this.bzr = this.cyr;
        this.bxi += this.ayi;
        this.ayi = this.bxi;
        this.cxi += this.azi;
        this.azi = this.cxi;
        this.cyi += this.bzi;
        this.bzi = this.cyi;
        return this;
    }

    public final Mat crossOperator(Vec vec) {
        this.axi = 0.0;
        this.axr = 0.0;
        this.bxr = vec.zr;
        this.bxi = vec.zi;
        this.cxr = -vec.yr;
        this.cxi = -vec.yi;
        this.ayr = -vec.zr;
        this.ayi = -vec.zi;
        this.byi = 0.0;
        this.byr = 0.0;
        this.cyr = vec.xr;
        this.cyi = vec.xi;
        this.azr = vec.yr;
        this.azi = vec.yi;
        this.bzr = -vec.xr;
        this.bzi = -vec.xi;
        this.czi = 0.0;
        this.czr = 0.0;
        return this;
    }

    public final int maxCrossOperatorIndex() {
        double d = this.cyr * this.cyr + this.cyi * this.cyi;
        double d2 = this.azr * this.azr + this.azi * this.azi;
        double d3 = this.bxr * this.bxr + this.bxi * this.bxi;
        if (d < 1.0E-10 && d2 < 1.0E-10 && d3 < 1.0E-10) {
            return 0;
        }
        if (d > d2 && d > d3) {
            return 1;
        }
        if (d2 > d3) {
            return 2;
        }
        return 3;
    }

    public final Mat makeRank1(Mat mat) {
        double d;
        double d2;
        switch (mat.maxCrossOperatorIndex()) {
            case 3: {
                d2 = -(this.axr * this.byr - this.axi * this.byi - (this.bxr * this.ayr - this.bxi * this.ayi));
                d = -(this.axi * this.byr + this.axr * this.byi - (this.bxi * this.ayr + this.bxr * this.ayi));
                double d3 = Math.sqrt(Math.sqrt(d2 * d2 + d * d));
                double d4 = Math.atan2(d, d2);
                d2 = d3 * Math.cos(d4 / 2.0);
                d = d3 * Math.sin(d4 / 2.0);
                double d5 = mat.bxr * mat.bxr + mat.bxi * mat.bxi;
                d3 = (d2 * mat.bxr + d * mat.bxi) / d5;
                d4 = (-d2 * mat.bxi + d * mat.bxr) / d5;
                d2 = d3;
                d = d4;
                break;
            }
            case 1: {
                d2 = -(this.byr * this.czr - this.byi * this.czi - (this.cyr * this.bzr - this.cyi * this.bzi));
                d = -(this.byi * this.czr + this.byr * this.czi - (this.cyi * this.bzr + this.cyr * this.bzi));
                double d6 = Math.sqrt(Math.sqrt(d2 * d2 + d * d));
                double d7 = Math.atan2(d, d2);
                d2 = d6 * Math.cos(d7 / 2.0);
                d = d6 * Math.sin(d7 / 2.0);
                double d8 = mat.cyr * mat.cyr + mat.cyi * mat.cyi;
                d6 = (d2 * mat.cyr + d * mat.cyi) / d8;
                d7 = (-d2 * mat.cyi + d * mat.cyr) / d8;
                d2 = d6;
                d = d7;
                break;
            }
            case 2: {
                d2 = -(this.czr * this.axr - this.czi * this.axi - (this.azr * this.cxr - this.azi * this.cxi));
                d = -(this.czi * this.axr + this.czr * this.axi - (this.azi * this.cxr + this.azr * this.cxi));
                double d9 = Math.sqrt(Math.sqrt(d2 * d2 + d * d));
                double d10 = Math.atan2(d, d2);
                d2 = d9 * Math.cos(d10 / 2.0);
                d = d9 * Math.sin(d10 / 2.0);
                double d11 = mat.azr * mat.azr + mat.azi * mat.azi;
                d9 = (d2 * mat.azr + d * mat.azi) / d11;
                d10 = (-d2 * mat.azi + d * mat.azr) / d11;
                d2 = d9;
                d = d10;
                break;
            }
            default: {
                return this;
            }
        }
        mat.mul(d2, d);
        this.add(mat);
        return this;
    }

    public final Mat makeRank1() {
        Vec vec = p;
        synchronized (vec) {
            Mat.p.xr = this.byr * this.czr - this.byi * this.czi - this.bzr * this.cyr + this.bzi * this.cyi;
            Mat.p.xi = this.byr * this.czi + this.byi * this.czr - this.bzr * this.cyi - this.bzi * this.cyr;
            Mat.p.yr = this.bzr * this.cxr - this.bzi * this.cxi - this.bxr * this.czr + this.bxi * this.czi;
            Mat.p.yi = this.bzr * this.cxi + this.bzi * this.cxr - this.bxr * this.czi - this.bxi * this.czr;
            Mat.p.zr = this.bxr * this.cyr - this.bxi * this.cyi - this.byr * this.cxr + this.byi * this.cxi;
            Mat.p.zi = this.bxr * this.cyi + this.bxi * this.cyr - this.byr * this.cxi - this.byi * this.cxr;
            if (p.abs2() < 1.0E-10) {
                Mat.p.xr = this.ayr * this.czr - this.ayi * this.czi - this.azr * this.cyr + this.azi * this.cyi;
                Mat.p.xi = this.ayr * this.czi + this.ayi * this.czr - this.azr * this.cyi - this.azi * this.cyr;
                Mat.p.yr = this.azr * this.cxr - this.azi * this.cxi - this.axr * this.czr + this.axi * this.czi;
                Mat.p.yi = this.azr * this.cxi + this.azi * this.cxr - this.axr * this.czi - this.axi * this.czr;
                Mat.p.zr = this.axr * this.cyr - this.axi * this.cyi - this.ayr * this.cxr + this.ayi * this.cxi;
                Mat.p.zi = this.axr * this.cyi + this.axi * this.cyr - this.ayr * this.cxi - this.ayi * this.cxr;
            }
            if (p.abs2() < 1.0E-10) {
                Mat.p.xr = this.ayr * this.bzr - this.ayi * this.bzi - this.azr * this.byr + this.azi * this.byi;
                Mat.p.xi = this.ayr * this.bzi + this.ayi * this.bzr - this.azr * this.byi - this.azi * this.byr;
                Mat.p.yr = this.azr * this.bxr - this.azi * this.bxi - this.axr * this.bzr + this.axi * this.bzi;
                Mat.p.yi = this.azr * this.bxi + this.azi * this.bxr - this.axr * this.bzi - this.axi * this.bzr;
                Mat.p.zr = this.axr * this.byr - this.axi * this.byi - this.ayr * this.bxr + this.ayi * this.bxi;
                Mat.p.zi = this.axr * this.byi + this.axi * this.byr - this.ayr * this.bxi - this.ayi * this.bxr;
            }
            l.crossOperator(p);
            this.makeRank1(l);
        }
        return this;
    }

    public final void assignVecsFromRank1Matrix(Vec vec, Vec vec2) {
        if (Mat.isNotNearZero(this.axr, this.axi)) {
            vec.assign(this.axr, this.axi, this.ayr, this.ayi, this.azr, this.azi);
            vec2.assign(this.axr, this.axi, this.bxr, this.bxi, this.cxr, this.cxi);
            return;
        }
        if (Mat.isNotNearZero(this.ayr, this.ayi)) {
            vec.assign(this.axr, this.axi, this.ayr, this.ayi, this.azr, this.azi);
            vec2.assign(this.ayr, this.ayi, this.byr, this.byi, this.cyr, this.cyi);
            return;
        }
        if (Mat.isNotNearZero(this.azr, this.ayr)) {
            vec.assign(this.axr, this.axi, this.ayr, this.ayi, this.azr, this.azi);
            vec2.assign(this.azr, this.azi, this.bzr, this.bzi, this.czr, this.czi);
            return;
        }
        if (Mat.isNotNearZero(this.bxr, this.bxi)) {
            vec.assign(this.bxr, this.bxi, this.byr, this.byi, this.bzr, this.bzi);
            vec2.assign(this.axr, this.axi, this.bxr, this.bxi, this.cxr, this.cxi);
            return;
        }
        if (Mat.isNotNearZero(this.byr, this.byi)) {
            vec.assign(this.bxr, this.bxi, this.byr, this.byi, this.bzr, this.bzi);
            vec2.assign(this.ayr, this.ayi, this.byr, this.byi, this.cyr, this.cyi);
            return;
        }
        if (Mat.isNotNearZero(this.bzr, this.bzi)) {
            vec.assign(this.bxr, this.bxi, this.byr, this.byi, this.bzr, this.bzi);
            vec2.assign(this.azr, this.azi, this.bzr, this.bzi, this.czr, this.czi);
            return;
        }
        if (Mat.isNotNearZero(this.cxr, this.cxi)) {
            vec.assign(this.cxr, this.cxi, this.cyr, this.cyi, this.czr, this.czi);
            vec2.assign(this.axr, this.axi, this.bxr, this.bxi, this.cxr, this.cxi);
            return;
        }
        if (Mat.isNotNearZero(this.cyr, this.cyi)) {
            vec.assign(this.cxr, this.cxi, this.cyr, this.cyi, this.czr, this.czi);
            vec2.assign(this.ayr, this.ayi, this.byr, this.byi, this.cyr, this.cyi);
            return;
        }
        if (Mat.isNotNearZero(this.czr, this.cyi)) {
            vec.assign(this.cxr, this.cxi, this.cyr, this.cyi, this.czr, this.czi);
            vec2.assign(this.azr, this.azi, this.bzr, this.bzi, this.czr, this.czi);
            return;
        }
        vec.setInvalide();
        vec2.setInvalide();
    }

    public final void intersectConicWithLine(Vec vec, Vec vec2, Vec vec3) {
        Mat mat = lCL;
        synchronized (mat) {
            Mat mat2 = sCL;
            synchronized (mat2) {
                lCL.crossOperator(vec);
                sCL.assign(lCL).t().mul(this).mul(lCL);
                sCL.makeRank1(lCL);
                sCL.assignVecsFromRank1Matrix(vec2, vec3);
            }
            return;
        }
    }

    public final void intersectCircleWithCircle(Mat mat, Vec vec, Vec vec2) {
        new Vec();
        new Vec();
        new Complex();
        Vec vec3 = lineCiCi;
        synchronized (vec3) {
            Vec vec4 = line1CiCi;
            synchronized (vec4) {
                lineCiCi.c(this).mul(mat.axr, mat.axi);
                line1CiCi.c(mat).mul(this.axr, this.axi);
                lineCiCi.sub(line1CiCi);
                Mat.lineCiCi.zr /= 2.0;
                Mat.lineCiCi.zi /= 2.0;
                lineCiCi.normalizeMax();
                this.intersectConicWithLine(lineCiCi, vec, vec2);
            }
            return;
        }
    }

    public final void intersectConicWithConic(Mat mat, Vec vec, Vec vec2, Vec vec3, Vec vec4) {
        CCa.det(this);
        CCc.mixedDet(this, mat);
        CCb.mixedDet(mat, this);
        CCd.det(mat);
        CCsol.solveCubic(CCa, CCb, CCc, CCd);
        CClambda.scalarProduct(CCsol, Vec.cub1);
        CCdeg.assign(this).mul(CClambda).add(mat);
        CCdeg.makeRank1();
        CCdeg.assignVecsFromRank1Matrix(CCl11, CCl12);
        CClambda.scalarProduct(CCsol, Vec.cub2);
        CCdeg.assign(this).mul(CClambda).add(mat);
        CCdeg.makeRank1();
        CCdeg.assignVecsFromRank1Matrix(CCl21, CCl22);
        vec.cross(CCl11, CCl21).normalizeAbs();
        vec2.cross(CCl12, CCl21).normalizeAbs();
        vec3.cross(CCl11, CCl22).normalizeAbs();
        vec4.cross(CCl12, CCl22).normalizeAbs();
    }

    public final Mat fit(Mat mat, Mat mat2, Vec vec) {
        double d = mat2.axr * vec.xr - mat2.axi * vec.xi + mat2.ayr * vec.yr - mat2.ayi * vec.yi + mat2.azr * vec.zr - mat2.azi * vec.zi;
        double d2 = mat2.bxr * vec.xr - mat2.bxi * vec.xi + mat2.byr * vec.yr - mat2.byi * vec.yi + mat2.bzr * vec.zr - mat2.bzi * vec.zi;
        double d3 = mat2.cxr * vec.xr - mat2.cxi * vec.xi + mat2.cyr * vec.yr - mat2.cyi * vec.yi + mat2.czr * vec.zr - mat2.czi * vec.zi;
        double d4 = mat2.axr * vec.xi + mat2.axi * vec.xr + mat2.ayr * vec.yi + mat2.ayi * vec.yr + mat2.azr * vec.zi + mat2.azi * vec.zr;
        double d5 = mat2.bxr * vec.xi + mat2.bxi * vec.xr + mat2.byr * vec.yi + mat2.byi * vec.yr + mat2.bzr * vec.zi + mat2.bzi * vec.zr;
        double d6 = mat2.cxr * vec.xi + mat2.cxi * vec.xr + mat2.cyr * vec.yi + mat2.cyi * vec.yr + mat2.czr * vec.zi + mat2.czi * vec.zr;
        double d7 = vec.xr * d - vec.xi * d4 + vec.yr * d2 - vec.yi * d5 + vec.zr * d3 - vec.zi * d6;
        double d8 = vec.xr * d4 + vec.xi * d + vec.yr * d5 + vec.yi * d2 + vec.zr * d6 + vec.zi * d3;
        d = mat.axr * vec.xr - mat.axi * vec.xi + mat.ayr * vec.yr - mat.ayi * vec.yi + mat.azr * vec.zr - mat.azi * vec.zi;
        d2 = mat.bxr * vec.xr - mat.bxi * vec.xi + mat.byr * vec.yr - mat.byi * vec.yi + mat.bzr * vec.zr - mat.bzi * vec.zi;
        d3 = mat.cxr * vec.xr - mat.cxi * vec.xi + mat.cyr * vec.yr - mat.cyi * vec.yi + mat.czr * vec.zr - mat.czi * vec.zi;
        d4 = mat.axr * vec.xi + mat.axi * vec.xr + mat.ayr * vec.yi + mat.ayi * vec.yr + mat.azr * vec.zi + mat.azi * vec.zr;
        d5 = mat.bxr * vec.xi + mat.bxi * vec.xr + mat.byr * vec.yi + mat.byi * vec.yr + mat.bzr * vec.zi + mat.bzi * vec.zr;
        d6 = mat.cxr * vec.xi + mat.cxi * vec.xr + mat.cyr * vec.yi + mat.cyi * vec.yr + mat.czr * vec.zi + mat.czi * vec.zr;
        double d9 = vec.xr * d - vec.xi * d4 + vec.yr * d2 - vec.yi * d5 + vec.zr * d3 - vec.zi * d6;
        double d10 = vec.xr * d4 + vec.xi * d + vec.yr * d5 + vec.yi * d2 + vec.zr * d6 + vec.zi * d3;
        this.axr = mat2.axr * d9 - mat2.axi * d10 - mat.axr * d7 + mat.axi * d8;
        this.axi = mat2.axr * d10 + mat2.axi * d9 - mat.axr * d8 - mat.axi * d7;
        this.ayr = mat2.ayr * d9 - mat2.ayi * d10 - mat.ayr * d7 + mat.ayi * d8;
        this.ayi = mat2.ayr * d10 + mat2.ayi * d9 - mat.ayr * d8 - mat.ayi * d7;
        this.azr = mat2.azr * d9 - mat2.azi * d10 - mat.azr * d7 + mat.azi * d8;
        this.azi = mat2.azr * d10 + mat2.azi * d9 - mat.azr * d8 - mat.azi * d7;
        this.bxr = mat2.bxr * d9 - mat2.bxi * d10 - mat.bxr * d7 + mat.bxi * d8;
        this.bxi = mat2.bxr * d10 + mat2.bxi * d9 - mat.bxr * d8 - mat.bxi * d7;
        this.byr = mat2.byr * d9 - mat2.byi * d10 - mat.byr * d7 + mat.byi * d8;
        this.byi = mat2.byr * d10 + mat2.byi * d9 - mat.byr * d8 - mat.byi * d7;
        this.bzr = mat2.bzr * d9 - mat2.bzi * d10 - mat.bzr * d7 + mat.bzi * d8;
        this.bzi = mat2.bzr * d10 + mat2.bzi * d9 - mat.bzr * d8 - mat.bzi * d7;
        this.cxr = mat2.cxr * d9 - mat2.cxi * d10 - mat.cxr * d7 + mat.cxi * d8;
        this.cxi = mat2.cxr * d10 + mat2.cxi * d9 - mat.cxr * d8 - mat.cxi * d7;
        this.cyr = mat2.cyr * d9 - mat2.cyi * d10 - mat.cyr * d7 + mat.cyi * d8;
        this.cyi = mat2.cyr * d10 + mat2.cyi * d9 - mat.cyr * d8 - mat.cyi * d7;
        this.czr = mat2.czr * d9 - mat2.czi * d10 - mat.czr * d7 + mat.czi * d8;
        this.czi = mat2.czr * d10 + mat2.czi * d9 - mat.czr * d8 - mat.czi * d7;
        return this;
    }

    public final Mat mul(Complex complex) {
        double d = this.axr * complex.real - this.axi * complex.imag;
        double d2 = this.axr * complex.imag + this.axi * complex.real;
        this.axr = d;
        this.axi = d2;
        d = this.ayr * complex.real - this.ayi * complex.imag;
        d2 = this.ayr * complex.imag + this.ayi * complex.real;
        this.ayr = d;
        this.ayi = d2;
        d = this.azr * complex.real - this.azi * complex.imag;
        d2 = this.azr * complex.imag + this.azi * complex.real;
        this.azr = d;
        this.azi = d2;
        d = this.bxr * complex.real - this.bxi * complex.imag;
        d2 = this.bxr * complex.imag + this.bxi * complex.real;
        this.bxr = d;
        this.bxi = d2;
        d = this.byr * complex.real - this.byi * complex.imag;
        d2 = this.byr * complex.imag + this.byi * complex.real;
        this.byr = d;
        this.byi = d2;
        d = this.bzr * complex.real - this.bzi * complex.imag;
        d2 = this.bzr * complex.imag + this.bzi * complex.real;
        this.bzr = d;
        this.bzi = d2;
        d = this.cxr * complex.real - this.cxi * complex.imag;
        d2 = this.cxr * complex.imag + this.cxi * complex.real;
        this.cxr = d;
        this.cxi = d2;
        d = this.cyr * complex.real - this.cyi * complex.imag;
        d2 = this.cyr * complex.imag + this.cyi * complex.real;
        this.cyr = d;
        this.cyi = d2;
        d = this.czr * complex.real - this.czi * complex.imag;
        d2 = this.czr * complex.imag + this.czi * complex.real;
        this.czr = d;
        this.czi = d2;
        return this;
    }

    public final Mat mul(double d, double d2) {
        double d3 = this.axr * d - this.axi * d2;
        double d4 = this.axr * d2 + this.axi * d;
        this.axr = d3;
        this.axi = d4;
        d3 = this.ayr * d - this.ayi * d2;
        d4 = this.ayr * d2 + this.ayi * d;
        this.ayr = d3;
        this.ayi = d4;
        d3 = this.azr * d - this.azi * d2;
        d4 = this.azr * d2 + this.azi * d;
        this.azr = d3;
        this.azi = d4;
        d3 = this.bxr * d - this.bxi * d2;
        d4 = this.bxr * d2 + this.bxi * d;
        this.bxr = d3;
        this.bxi = d4;
        d3 = this.byr * d - this.byi * d2;
        d4 = this.byr * d2 + this.byi * d;
        this.byr = d3;
        this.byi = d4;
        d3 = this.bzr * d - this.bzi * d2;
        d4 = this.bzr * d2 + this.bzi * d;
        this.bzr = d3;
        this.bzi = d4;
        d3 = this.cxr * d - this.cxi * d2;
        d4 = this.cxr * d2 + this.cxi * d;
        this.cxr = d3;
        this.cxi = d4;
        d3 = this.cyr * d - this.cyi * d2;
        d4 = this.cyr * d2 + this.cyi * d;
        this.cyr = d3;
        this.cyi = d4;
        d3 = this.czr * d - this.czi * d2;
        d4 = this.czr * d2 + this.czi * d;
        this.czr = d3;
        this.czi = d4;
        return this;
    }

    public final Mat mul(double d) {
        this.axr *= d;
        this.ayr *= d;
        this.azr *= d;
        this.bxr *= d;
        this.byr *= d;
        this.bzr *= d;
        this.cxr *= d;
        this.cyr *= d;
        this.czr *= d;
        this.axi *= d;
        this.ayi *= d;
        this.azi *= d;
        this.bxi *= d;
        this.byi *= d;
        this.bzi *= d;
        this.cxi *= d;
        this.cyi *= d;
        this.czi *= d;
        return this;
    }

    public final String toString() {
        if (this.invalid == 0) {
            return "[[" + this.axr + "+i*" + this.axi + " , " + this.bxr + "+i*" + this.bxi + " , " + this.cxr + "+i*" + this.cxi + "]\n" + " [" + this.ayr + "+i*" + this.ayi + " , " + this.byr + "+i*" + this.byi + " , " + this.cyr + "+i*" + this.cyi + "]\n" + " [" + this.azr + "+i*" + this.azi + " , " + this.bzr + "+i*" + this.bzi + " , " + this.czr + "+i*" + this.czi + "]]";
        }
        return "[[" + this.axr + "+i*" + this.axi + " , " + this.bxr + "+i*" + this.bxi + " , " + this.cxr + "+i*" + this.cxi + "]\n" + " [" + this.ayr + "+i*" + this.ayi + " , " + this.byr + "+i*" + this.byi + " , " + this.cyr + "+i*" + this.cyi + "]\n" + " [" + this.azr + "+i*" + this.azi + " , " + this.bzr + "+i*" + this.bzi + " , " + this.czr + "+i*" + this.czi + "]] invalid";
    }

    public final String toPrintString() {
        return "[]";
    }

    public final void eigenValues(Complex complex, Complex complex2, Complex complex3) {
        double d = this.detReal();
        double d2 = this.detImag();
        EVb.mixedDet(idneg, this);
        double d3 = this.spurReal();
        double d4 = this.spurImag();
        EVsol.solveCubic(-1.0, 0.0, d3, d4, Mat.EVb.real, Mat.EVb.imag, d, d2);
        complex.scalarProduct(EVsol, Vec.cub1);
        complex2.scalarProduct(EVsol, Vec.cub2);
        complex3.scalarProduct(EVsol, Vec.cub3);
    }

    public final double detReal() {
        return this.axr * this.byr * this.czr - this.axi * this.byi * this.czr - this.axi * this.byr * this.czi - this.axr * this.byi * this.czi + this.azr * this.bxr * this.cyr - this.azi * this.bxi * this.cyr - this.azi * this.bxr * this.cyi - this.azr * this.bxi * this.cyi + this.ayr * this.bzr * this.cxr - this.ayi * this.bzi * this.cxr - this.ayi * this.bzr * this.cxi - this.ayr * this.bzi * this.cxi - this.axr * this.bzr * this.cyr + this.axi * this.bzi * this.cyr + this.axi * this.bzr * this.cyi + this.axr * this.bzi * this.cyi - this.azr * this.byr * this.cxr + this.azi * this.byi * this.cxr + this.azi * this.byr * this.cxi + this.azr * this.byi * this.cxi - this.ayr * this.bxr * this.czr + this.ayi * this.bxi * this.czr + this.ayi * this.bxr * this.czi + this.ayr * this.bxi * this.czi;
    }

    public final double detImag() {
        return -this.axi * this.byi * this.czi + this.axi * this.byr * this.czr + this.axr * this.byr * this.czi + this.axr * this.byi * this.czr - this.azi * this.bxi * this.cyi + this.azi * this.bxr * this.cyr + this.azr * this.bxr * this.cyi + this.azr * this.bxi * this.cyr - this.ayi * this.bzi * this.cxi + this.ayi * this.bzr * this.cxr + this.ayr * this.bzr * this.cxi + this.ayr * this.bzi * this.cxr + this.axi * this.bzi * this.cyi - this.axi * this.bzr * this.cyr - this.axr * this.bzr * this.cyi - this.axr * this.bzi * this.cyr + this.azi * this.byi * this.cxi - this.azi * this.byr * this.cxr - this.azr * this.byr * this.cxi - this.azr * this.byi * this.cxr + this.ayi * this.bxi * this.czi - this.ayi * this.bxr * this.czr - this.ayr * this.bxr * this.czi - this.ayr * this.bxi * this.czr;
    }

    public final double spurReal() {
        return this.axr + this.byr + this.czr;
    }

    public final double spurImag() {
        return this.axi + this.byi + this.czi;
    }

    public final Mat normalizeMax() {
        this.invalid = 0;
        Complex complex = ct;
        synchronized (complex) {
            ct.maxValue(this);
            ct.inv();
            this.mul(ct);
        }
        return this;
    }

    public final boolean normalizeMaxValid(int n) {
        this.invalid = 0;
        Complex complex = ct;
        synchronized (complex) {
            ct.maxValue(this);
            if (n != 0 || Mat.ct.real * Mat.ct.real + Mat.ct.imag * Mat.ct.imag < 1.0E-18) {
                this.setInvalide();
                boolean bl = false;
                Object var4_4 = null;
                return bl;
            }
            ct.inv();
            this.mul(ct);
        }
        return true;
    }

    public final boolean isEllipse() {
        double d = this.axr * this.byr - this.axi * this.byi - (this.ayr * this.bxr - this.ayi * this.bxi);
        double d2 = this.axr * this.byi - this.axi * this.byr - (this.ayr * this.bxi + this.ayi * this.bxr);
        return d2 < 1.0E-10 && d2 > -1.0E-10 && d > 0.0;
    }

    public final boolean isAlmostReal() {
        return this.axi > -1.0E-6 && this.axi < 1.0E-6 && this.ayi > -1.0E-6 && this.ayi < 1.0E-6 && this.azi > -1.0E-6 && this.azi < 1.0E-6 && this.bxi > -1.0E-6 && this.bxi < 1.0E-6 && this.byi > -1.0E-6 && this.byi < 1.0E-6 && this.bzi > -1.0E-6 && this.bzi < 1.0E-6 && this.cxi > -1.0E-6 && this.cxi < 1.0E-6 && this.cyi > -1.0E-6 && this.cyi < 1.0E-6 && this.czi > -1.0E-6 && this.czi < 1.0E-6;
    }

    public static final boolean isNotNearZero(double d, double d2) {
        return d > 1.0E-10 || d2 > 1.0E-10 || d < -1.0E-10 || d2 < -1.0E-10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAlmostEqual(Mat mat) {
        Vec vec = ranv;
        synchronized (vec) {
            Complex complex = ran1;
            synchronized (complex) {
                Complex complex2 = ran2;
                synchronized (complex2) {
                    Complex complex3 = ran3;
                    synchronized (complex3) {
                        ranv.random();
                        ran1.matrixEval(this, ranv);
                        ran2.matrixEval(mat, ranv);
                        ranv.random();
                        ran3.matrixEval(this, ranv);
                        ran2.mul(ran3);
                        ran3.matrixEval(mat, ranv);
                        ran1.mul(ran3).sub(ran2);
                        if (!ran1.isAlmostZero()) {
                            return false;
                        }
                        ranv.random();
                        ran1.matrixEval(this, ranv);
                        ran2.matrixEval(mat, ranv);
                        ranv.random();
                        ran3.matrixEval(this, ranv);
                        ran2.mul(ran3);
                        ran3.matrixEval(mat, ranv);
                        ran1.mul(ran3).sub(ran2);
                        if (ran1.isAlmostZero()) return true;
                        return false;
                    }
                }
            }
        }
    }

    public final Mat adjoint(Mat mat) {
        double d = mat.byr * mat.czr - mat.byi * mat.czi - mat.bzr * mat.cyr + mat.bzi * mat.cyi;
        double d2 = mat.byr * mat.czi + mat.byi * mat.czr - mat.bzr * mat.cyi - mat.bzi * mat.cyr;
        double d3 = mat.bzr * mat.cxr - mat.bzi * mat.cxi - mat.bxr * mat.czr + mat.bxi * mat.czi;
        double d4 = mat.bzr * mat.cxi + mat.bzi * mat.cxr - mat.bxr * mat.czi - mat.bxi * mat.czr;
        double d5 = mat.bxr * mat.cyr - mat.bxi * mat.cyi - mat.byr * mat.cxr + mat.byi * mat.cxi;
        double d6 = mat.bxr * mat.cyi + mat.bxi * mat.cyr - mat.byr * mat.cxi - mat.byi * mat.cxr;
        double d7 = mat.cyr * mat.azr - mat.cyi * mat.azi - mat.czr * mat.ayr + mat.czi * mat.ayi;
        double d8 = mat.cyr * mat.azi + mat.cyi * mat.azr - mat.czr * mat.ayi - mat.czi * mat.ayr;
        double d9 = mat.czr * mat.axr - mat.czi * mat.axi - mat.cxr * mat.azr + mat.cxi * mat.azi;
        double d10 = mat.czr * mat.axi + mat.czi * mat.axr - mat.cxr * mat.azi - mat.cxi * mat.azr;
        double d11 = mat.cxr * mat.ayr - mat.cxi * mat.ayi - mat.cyr * mat.axr + mat.cyi * mat.axi;
        double d12 = mat.cxr * mat.ayi + mat.cxi * mat.ayr - mat.cyr * mat.axi - mat.cyi * mat.axr;
        double d13 = mat.ayr * mat.bzr - mat.ayi * mat.bzi - mat.azr * mat.byr + mat.azi * mat.byi;
        double d14 = mat.ayr * mat.bzi + mat.ayi * mat.bzr - mat.azr * mat.byi - mat.azi * mat.byr;
        double d15 = mat.azr * mat.bxr - mat.azi * mat.bxi - mat.axr * mat.bzr + mat.axi * mat.bzi;
        double d16 = mat.azr * mat.bxi + mat.azi * mat.bxr - mat.axr * mat.bzi - mat.axi * mat.bzr;
        double d17 = mat.axr * mat.byr - mat.axi * mat.byi - mat.ayr * mat.bxr + mat.ayi * mat.bxi;
        double d18 = mat.axr * mat.byi + mat.axi * mat.byr - mat.ayr * mat.bxi - mat.ayi * mat.bxr;
        this.axr = d;
        this.axi = d2;
        this.ayr = d3;
        this.ayi = d4;
        this.azr = d5;
        this.azi = d6;
        this.bxr = d7;
        this.bxi = d8;
        this.byr = d9;
        this.byi = d10;
        this.bzr = d11;
        this.bzi = d12;
        this.cxr = d13;
        this.cxi = d14;
        this.cyr = d15;
        this.cyi = d16;
        this.czr = d17;
        this.czi = d18;
        return this;
    }

    static {
        new Mat(1.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        idneg = new Mat(-1.0, -1.0, -1.0, 0.0, 0.0, 0.0);
        ct = new Complex();
        p = new Vec();
        l = new Mat();
        new Mat();
        lCL = new Mat();
        sCL = new Mat();
        lineCiCi = new Vec();
        line1CiCi = new Vec();
        CCsol = new Vec();
        new Vec();
        CCl12 = new Vec();
        CCl11 = new Vec();
        CCl21 = new Vec();
        CCl22 = new Vec();
        CCa = new Complex();
        CCb = new Complex();
        CCc = new Complex();
        CCd = new Complex();
        CClambda = new Complex();
        CCdeg = new Mat();
        EVsol = new Vec();
        EVb = new Complex();
        new Mat();
        ran1 = new Complex();
        ran2 = new Complex();
        ran3 = new Complex();
        ranv = new Vec();
    }
}

