/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import java.awt.Color;
import java.io.Serializable;

public final class MixColor
implements Serializable {
    public Color full;
    public Color[] level = new Color[10];
    public Color[] darker = new Color[10];

    public MixColor(Color color) {
        this(color, color);
    }

    public MixColor(Color color, Color color2) {
        this.full = color;
        Color color3 = this.mix(color, Color.black, 0.7);
        int n = 9;
        while (n >= 0) {
            this.level[n] = this.mix(color, color2, (double)n / 9.0);
            this.darker[n] = this.mix(color3, color2, (double)n / 9.0);
            --n;
        }
    }

    public MixColor(Color color, MixColor mixColor) {
        this(color, mixColor.full);
    }

    public final Color mix(Color color, Color color2, double d) {
        return new Color((int)((1.0 - d) * (double)color2.getRed() + d * (double)color.getRed()), (int)((1.0 - d) * (double)color2.getGreen() + d * (double)color.getGreen()), (int)((1.0 - d) * (double)color2.getBlue() + d * (double)color.getBlue()));
    }

    public final String toString() {
        return this.full.toString();
    }
}

