/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.Preferences;
import de.cinderella.controls.ResourceImage;
import de.cinderella.controls.ToolTip;
import de.cinderella.ports.Appearance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class ImageButton
extends Component
implements MouseListener,
MouseMotionListener,
FocusListener,
KeyListener,
Observer {
    public Image pressedImage;
    public Image normalImage;
    public Color pressedColor;
    public Color normalColor;
    public Dimension d = new Dimension();
    public Vector listeners = new Vector();
    public String t;
    public String text;
    public String ttt;
    public Point pos;
    public Font font;
    public boolean down = false;
    public boolean pressed = false;
    public boolean active = false;
    public boolean focus = false;
    public int tx;
    public int ty;

    public ImageButton() {
        this.pressedColor = new Color(152, 152, 152);
        this.normalColor = new Color(192, 192, 192);
        this.font = Appearance.helvetica;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public ImageButton(String string) {
        this();
        this.setText(string);
    }

    public ImageButton(String string, String string2) {
        this();
        if (string2 != null && !string2.equals("")) {
            this.setImage(ResourceImage.getImage(string2));
            this.pressedImage = ResourceImage.getDarkImage(string2);
            return;
        }
        this.setText(string);
    }

    public final void paint(Graphics graphics) {
        int n = this.d.width;
        int n2 = this.d.height;
        if (this.normalImage != null) {
            graphics.drawImage(this.down || this.pressed ? this.pressedImage : this.normalImage, 0, 0, n, n2, this);
        } else {
            graphics.setFont(this.font);
            if (this.down || this.pressed) {
                graphics.setColor(this.pressedColor);
            } else {
                graphics.setColor(this.normalColor);
            }
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.lightGray);
            if (this.text != null || this.down || this.pressed) {
                graphics.draw3DRect(0, 0, n - 1, n2 - 1, false);
                graphics.draw3DRect(1, 1, n - 3, n2 - 3, true);
            }
            if (this.text != null) {
                graphics.setColor(Color.black);
                graphics.drawString(this.text, this.tx, this.ty);
            }
        }
        if (this.focus) {
            graphics.setColor(Color.white);
            graphics.drawRect(2, 2, this.d.width - 4, this.d.height - 4);
        }
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void setImage(Image image) {
        this.normalImage = image;
        this.d.width = (int)((double)image.getWidth(this) * Preferences.getDouble("cinderella.imagebutton.scale", 1.0));
        this.d.height = (int)((double)image.getHeight(this) * Preferences.getDouble("cinderella.imagebutton.scale", 1.0));
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        ToolTip.stopTimer();
        if (this.active) {
            this.mouseReleased(mouseEvent);
        }
        if (!this.active) {
            this.active = true;
            this.pressed = true;
            this.repaint();
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        if (!this.active) {
            this.mousePressed(mouseEvent);
        }
        if (this.pressed != this.contains(mouseEvent.getPoint())) {
            this.pressed = !this.pressed;
            this.repaint();
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (!this.active) {
            this.mousePressed(mouseEvent);
        }
        this.active = false;
        this.pressed = this.contains(mouseEvent.getPoint());
        if (this.pressed) {
            this.pressed = false;
            this.select();
        }
        this.repaint();
    }

    public final void on() {
        if (!this.down || this.pressed) {
            this.down = true;
            this.pressed = false;
            this.repaint();
        }
    }

    public final void off() {
        if (this.down || this.pressed) {
            this.down = false;
            this.pressed = false;
            this.repaint();
        }
    }

    public final void setState(boolean bl) {
        if (bl) {
            this.on();
            return;
        }
        this.off();
    }

    public final Dimension getPreferredSize() {
        return this.d;
    }

    public final void setText(String string) {
        this.text = string;
        FontMetrics fontMetrics = Appearance.helvFM;
        this.d.width = fontMetrics.stringWidth(string) + 14;
        this.d.height = Appearance.helvA + Appearance.helvD + 14;
        this.tx = 7;
        this.ty = Appearance.helvA + 7;
        if (this.t == null) {
            this.t = string;
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public final void select() {
        Vector vector;
        ToolTip.stopTimer();
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((ActionListener)vector.elementAt(n)).actionPerformed(new ActionEvent(this, 1001, this.t));
            ++n;
        }
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        ToolTip.setPos(this.getPos());
        ToolTip.setText(this.ttt);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ToolTip.stopTimer();
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        ToolTip.setText(null);
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        ToolTip.resetTimer();
    }

    public final Point getPos() {
        this.pos = this.getLocationOnScreen();
        this.pos.x += this.getSize().width * 3 / 4;
        this.pos.y += this.getSize().height + 10;
        return this.pos;
    }

    public final boolean isFocusTraversable() {
        return true;
    }

    public final void focusGained(FocusEvent focusEvent) {
        this.focus = true;
        this.repaint();
    }

    public final void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        this.repaint();
    }

    public final void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
            this.mousePressed(new MouseEvent(keyEvent.getComponent(), 501, keyEvent.getWhen(), keyEvent.getModifiers(), 1, 1, 0, false));
        }
    }

    public final void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
            this.mouseReleased(new MouseEvent(keyEvent.getComponent(), 502, keyEvent.getWhen(), keyEvent.getModifiers(), 1, 1, 0, false));
        }
    }

    public final void keyTyped(KeyEvent keyEvent) {
    }

    public void update(Observable observable, Object object) {
    }
}

