/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.controls.ColorTable;
import de.cinderella.controls.Intl;
import de.cinderella.controls.ObservableBool;
import de.cinderella.controls.Preferences;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGText;
import de.cinderella.geometry.Program;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Vec;
import de.cinderella.ports.Appearance;
import de.cinderella.ports.GenericListener;
import de.cinderella.ports.Hinter;
import de.cinderella.ports.Resizable;
import de.cinderella.ports.ViewPortElement;
import de.cinderella.ports.ViewPortElements;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.util.Observable;
import java.util.Observer;

public abstract class ViewPort
extends Component
implements ComponentListener,
Observer {
    public transient Program myProgram;
    public transient Cindy kernel;
    public ObservableBool db;
    public transient int ID;
    public transient int iID;
    public Hinter hint;
    public boolean polar;
    public ViewPortElement labelMove;
    public boolean complex = false;
    public boolean isInitialized = false;
    public Frame frame;
    public ViewPortElements elements;
    public double opacity;
    public ColorTable pointCT;
    public ColorTable lineCT;
    public ColorTable polyCT;
    public ColorTable lociCT;
    public Dimension oD;
    public int width;
    public int height;
    public Graphics oG;
    public Image oI;
    public Dimension pref;
    public GenericListener myListener;

    public ViewPort() {
        new Vec();
        this.elements = new ViewPortElements(this);
        this.opacity = 0.3;
        this.pref = new Dimension(630, 350);
        this.addComponentListener(this);
        this.db = new ObservableBool("double-buffer", Preferences.getBoolean("cinderella.double-buffer"));
        this.db.addObserver(this);
    }

    public final String windowTitle() {
        if (this.myProgram.filename == null) {
            return Intl.getMessage("cindy");
        }
        return String.valueOf(Intl.getMessage("cindy")) + ": " + this.myProgram.filename;
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void setID(int n) {
        this.ID = n;
        this.iID = ~n;
    }

    public void setKernel(Cindy cindy) {
        this.kernel = cindy;
        if (this.myListener != null) {
            this.removeMouseListener();
        }
        this.myListener = new GenericListener(cindy);
        this.addMouseListener(this.myListener);
        this.addMouseMotionListener(this.myListener);
        this.pointCT = this.polar ? cindy.f18.lineCT : cindy.f18.pointCT;
        this.lineCT = this.polar ? cindy.f18.pointCT : cindy.f18.lineCT;
        this.polyCT = cindy.f18.polyCT;
        this.lociCT = cindy.f18.lociCT;
    }

    public final void removeMouseListener() {
        this.removeMouseListener(this.myListener);
        this.removeMouseMotionListener(this.myListener);
    }

    public final void forceRecalc() {
        this.elements.forceRecalc();
    }

    public void paintMesh(Graphics graphics) {
    }

    public void paintAfterMesh(Graphics graphics) {
    }

    public void setPortFont(Graphics graphics) {
        graphics.setFont(Appearance.labelfont);
    }

    public void paint(Graphics graphics) {
        if (this.oG == null) {
            this.oG = graphics;
        }
        this.setPortFont(this.oG);
        this.elements.recalc();
        this.elements.recalcTmp();
        this.oG.setColor(this.pointCT.background.full);
        this.oG.fillRect(0, 0, this.width, this.height);
        if (this.hint != null) {
            this.hint.drawPreHint(this.oG, this);
        }
        this.paintMesh(this.oG);
        switch (this.kernel.f33) {
            case 1: {
                this.elements.draft(this.oG);
                break;
            }
            case 2: {
                this.elements.draw(this.oG);
                break;
            }
            case 0: {
                this.elements.draw(this.oG);
                break;
            }
        }
        if (this.hint != null) {
            this.hint.drawPostHint(this.oG, this);
        }
        this.elements.drawLabel(this.oG);
        this.paintAfterMesh(this.oG);
        if (this.oI != null) {
            graphics.drawImage(this.oI, 0, 0, this);
            return;
        }
        this.oG = null;
    }

    public void print(PrintJob printJob) {
    }

    public final Dimension getMinimumSize() {
        return this.pref;
    }

    public final Dimension getPreferredSize() {
        return this.pref;
    }

    public abstract void toVec(int var1, int var2, Vec var3);

    public abstract void toVec(Point var1, Vec var2);

    public abstract boolean toPoint(Vec var1, Point var2);

    public abstract boolean toPoint(Vec var1, DoublePoint var2);

    public abstract ViewPortElement fittingPGElement(PGElement var1);

    public void toVecGrid(Point point, Vec vec) {
        this.toVec(point, vec);
    }

    public void addTmpPGElement(PGElement pGElement) {
        ViewPortElement viewPortElement = this.fittingPGElement(pGElement);
        if (viewPortElement != null) {
            if (viewPortElement instanceof Resizable) {
                ((Resizable)((Object)viewPortElement)).resize(this.width, this.height);
            }
            this.elements.addTmp(viewPortElement);
        }
    }

    public void addPGElement(PGElement pGElement) {
        ViewPortElement viewPortElement = this.fittingPGElement(pGElement);
        if (viewPortElement != null) {
            if (viewPortElement instanceof Resizable) {
                ((Resizable)((Object)viewPortElement)).resize(this.width, this.height);
            }
            this.elements.add(viewPortElement);
            pGElement.f9.changed |= this.ID;
        }
    }

    public void reset() {
        this.elements.clear();
    }

    public void softReset() {
    }

    public final void redock(PGText pGText, int n, int n2, Vec vec) {
        if (n < 30) {
            pGText.f131.x = 10;
            if (n2 < this.height / 2) {
                pGText.f129 = 2;
                pGText.f131.y = (n2 + 20) / 20 * 20;
                return;
            }
            pGText.f129 = 4;
            pGText.f131.y = -(this.height / 20 * 20 - (n2 + 20) / 20 * 20);
            return;
        }
        if (n + 90 > this.width) {
            pGText.f131.x = -100;
            if (n2 < this.height / 2) {
                pGText.f129 = 3;
                pGText.f131.y = (n2 + 20) / 20 * 20;
                return;
            }
            pGText.f129 = 5;
            pGText.f131.y = -(this.height / 20 * 20 - (n2 + 20) / 20 * 20);
            return;
        }
        if (n2 <= 40) {
            pGText.f131.y = (n2 + 20) / 20 * 20;
            pGText.f129 = 2;
            pGText.f131.x = n;
            return;
        }
        if (n2 + 50 >= this.height) {
            pGText.f131.y = -(this.height / 20 * 20 - (n2 + 20) / 20 * 20);
            pGText.f129 = 4;
            pGText.f131.x = n;
            return;
        }
        PGElement pGElement = this.elements.findDockable(n, n2, pGText.f128);
        if (pGElement != null) {
            boolean bl = pGElement != pGText.f128;
            pGElement.m7(pGText, this, n, n2, vec);
            if (bl) {
                this.kernel.f15.reparseTexts(pGElement);
                return;
            }
        } else {
            pGText.f129 = 0;
            pGText.f128 = null;
            pGText.m40(vec);
            pGText.f131.x = 0;
            pGText.f131.y = 0;
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.oD = this.getSize();
        this.width = this.oD.width;
        this.height = this.oD.height;
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.softReset();
        }
        if (this.width > 0 && this.height > 0) {
            if (this.db.value) {
                try {
                    if (this.oG != null) {
                        this.oG.dispose();
                    }
                    if (this.oI != null) {
                        this.oI.flush();
                    }
                    this.oI = this.createImage(this.oD.width, this.oD.height);
                    this.oG = this.oI.getGraphics();
                    this.oG.setFont(Appearance.labelfont);
                    System.gc();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.oI = null;
            this.oG = null;
            System.gc();
        }
    }

    public final void componentMoved(ComponentEvent componentEvent) {
    }

    public final void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    public final void componentHidden(ComponentEvent componentEvent) {
    }

    public void writeHTML(PrintWriter printWriter) {
        printWriter.println("<param  name=doublebuffer value= \"" + this.db.value + "\">");
    }

    public void update(Observable observable, Object object) {
        if (observable == this.db) {
            this.componentResized(null);
        }
        this.validate();
        this.repaint();
    }

    public void printPS() {
    }

    public int PSw() {
        return this.width;
    }

    public int PSh() {
        return this.height;
    }

    public int PSxOffset() {
        return 0;
    }

    public int PSyOffset() {
        return 0;
    }
}

