/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.controls.ObservableInt;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Matrix3D;
import de.cinderella.math.Vec;
import de.cinderella.ports.Appearance;
import de.cinderella.ports.PSHandler;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.util.Observable;

public final class SphericalPort
extends ViewPort
implements ComponentListener {
    public Matrix3D f287 = new Matrix3D();
    public Point f42 = new Point();
    public int f288;
    public double f289 = 1.0;
    public double f290 = 1.0;
    public ObservableInt f291 = new ObservableInt("scaleSphere", 500);
    public Vec f50 = new Vec();
    public Vec f292 = new Vec();

    public SphericalPort() {
        this.f291.addObserver(this);
        this.pref = new Dimension(400, 400);
    }

    public final ViewPortElement fittingPGElement(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            if (this.polar) {
                return new c119(pGElement, this);
            }
            return new c117(pGElement, this);
        }
        if (pGElement instanceof PGLine) {
            if (this.polar) {
                return new c117(pGElement, this);
            }
            return new c119(pGElement, this);
        }
        if (pGElement instanceof PGSegment) {
            if (this.polar) {
                return new c117(pGElement, this);
            }
            return new c119(pGElement, this);
        }
        if (pGElement instanceof PGConic) {
            return new c118(pGElement, this);
        }
        if (pGElement instanceof PGLocus) {
            return new c116(pGElement, this);
        }
        if (pGElement instanceof PGPolygon) {
            if (this.polar) {
                return null;
            }
            return new c114(pGElement, this);
        }
        return null;
    }

    public final void toVec(Point point, Vec vec) {
        this.toVec(point.x, point.y, vec);
    }

    public final void toVec(int n, int n2, Vec vec) {
        double d;
        double d2;
        double d3 = 1.0 - (d2 = (double)(n - this.f42.x) / (double)this.f288) * d2 - (d = (double)(n2 - this.f42.y) / (double)this.f288) * d;
        this.f50.assign(d2, d, d3 > 0.0 ? Math.sqrt(d3) : 0.0);
        this.f287.transform(this.f50, vec);
        vec.xr *= this.f289;
        vec.yr *= this.f289;
        vec.xi *= this.f289;
        vec.yi *= this.f289;
    }

    public final boolean toPoint(Vec vec, Point point) {
        this.f292.assign(vec);
        this.f292.xr *= this.f290;
        this.f292.yr *= this.f290;
        this.f292.xi *= this.f290;
        this.f292.yi *= this.f290;
        this.f292.normalizeAbs();
        this.f287.inversetfm(this.f292, this.f50);
        point.move((int)(this.f50.xr * (double)this.f288 + (double)this.f42.x), (int)(this.f50.yr * (double)this.f288 + (double)this.f42.y));
        return true;
    }

    public final boolean toPoint(Vec vec, DoublePoint doublePoint) {
        this.f292.assign(vec);
        this.f292.xr *= this.f290;
        this.f292.yr *= this.f290;
        this.f292.xi *= this.f290;
        this.f292.yi *= this.f290;
        this.f292.normalizeAbs();
        this.f287.inversetfm(this.f292, this.f50);
        doublePoint.x = this.f50.xr * (double)this.f288 + (double)this.f42.x;
        doublePoint.y = this.f50.yr * (double)this.f288 + (double)this.f42.y;
        return true;
    }

    public final boolean m95(Vec vec, Point point) {
        this.f292.assign(vec);
        this.f292.xr *= this.f290;
        this.f292.yr *= this.f290;
        this.f292.xi *= this.f290;
        this.f292.yi *= this.f290;
        this.f292.normalizeAbs();
        this.f287.inversetfm(this.f292, this.f50);
        point.move((int)(this.f50.xr * (double)this.f288 + (double)this.f42.x), (int)(this.f50.yr * (double)this.f288 + (double)this.f42.y));
        return this.f50.zr > 0.0;
    }

    public final void m96(Vec vec, int n, DoublePoint doublePoint) {
        this.f292.assign(vec);
        this.f292.xr *= this.f290;
        this.f292.yr *= this.f290;
        this.f292.xi *= this.f290;
        this.f292.yi *= this.f290;
        this.f292.normalizeAbs();
        this.f287.inversetfm(this.f292, this.f50);
        if (this.f50.zr < 0.0) {
            this.f50.mul(-1.0);
        }
        doublePoint.move((double)n * this.f50.xr * (double)this.f288 + (double)this.f42.x, (double)n * this.f50.yr * (double)this.f288 + (double)this.f42.y);
    }

    public final void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.width > 0 && this.height > 0) {
            this.f288 = this.width < this.height ? (int)((double)(this.width / 2) - (double)this.width * 0.07) : (int)((double)(this.height / 2) - (double)this.height * 0.07);
            this.f42.x = this.width / 2;
            this.f42.y = this.height / 2;
            this.elements.resize(this.width, this.height);
            this.elements.forceRecalc();
        }
    }

    public final void paint(Graphics graphics) {
        if (this.oG == null) {
            this.oG = graphics;
            this.oG.setFont(Appearance.textfont);
        }
        this.elements.recalc();
        this.elements.recalcTmp();
        this.oG.setColor(Color.gray);
        this.oG.fillRect(0, 0, this.width, this.height);
        this.oG.setColor(this.pointCT.background.full);
        this.oG.fillOval(this.f42.x - this.f288, this.f42.y - this.f288, 2 * this.f288, 2 * this.f288);
        switch (this.kernel.f33) {
            case 2: {
                this.elements.draftBack(this.oG);
                break;
            }
            case 1: {
                this.elements.draftBack(this.oG);
                break;
            }
            case 0: {
                this.elements.drawBack(this.oG);
            }
        }
        this.oG.setColor(Color.blue);
        this.oG.drawOval(this.f42.x - this.f288, this.f42.y - this.f288, 2 * this.f288, 2 * this.f288);
        switch (this.kernel.f33) {
            case 2: {
                this.elements.draft(this.oG);
                break;
            }
            case 1: {
                this.elements.draft(this.oG);
                break;
            }
            case 0: {
                this.elements.draw(this.oG);
            }
        }
        this.elements.drawLabel(this.oG);
        if (this.oI != null) {
            graphics.drawImage(this.oI, 0, 0, this);
            return;
        }
        this.oG = null;
    }

    public final void print(PrintJob printJob) {
        int n = printJob.getPageDimension().width - 40;
        int n2 = printJob.getPageDimension().height - 40;
        Graphics graphics = printJob.getGraphics();
        graphics.translate(20, 20);
        graphics.translate((n - this.width) / 2, (n2 - this.height) / 2);
        graphics.setColor(Color.black);
        graphics.setClip(0, 0, this.width, this.height);
        graphics.setFont(Appearance.textfont);
        super.forceRecalc();
        graphics.setColor(this.pointCT.background.full);
        graphics.fillOval(this.f42.x - this.f288, this.f42.y - this.f288, 2 * this.f288, 2 * this.f288);
        this.elements.drawBack(graphics);
        graphics.setColor(Color.blue);
        graphics.drawOval(this.f42.x - this.f288, this.f42.y - this.f288, 2 * this.f288, 2 * this.f288);
        this.elements.draw(graphics);
        this.elements.drawLabel(graphics);
        graphics.dispose();
    }

    public final void update(Observable observable, Object object) {
        double d = (double)((ObservableInt)observable).value / 100.0 - 5.0;
        this.f289 = Math.exp(d);
        this.f290 = 1.0 / this.f289;
        super.forceRecalc();
        this.repaint();
    }

    public final void writeHTML(PrintWriter printWriter) {
        super.writeHTML(printWriter);
        printWriter.println("<param  name=scal value=\"" + this.f289 + "\">");
        printWriter.println("<param  name=scalinv value=\"" + this.f290 + "\">");
        printWriter.println("<param  name=mapxx value=\"" + this.f287.xx + "\">");
        printWriter.println("<param  name=mapxy value=\"" + this.f287.xy + "\">");
        printWriter.println("<param  name=mapxz value=\"" + this.f287.xz + "\">");
        printWriter.println("<param  name=mapyx value=\"" + this.f287.yx + "\">");
        printWriter.println("<param  name=mapyy value=\"" + this.f287.yy + "\">");
        printWriter.println("<param  name=mapyz value=\"" + this.f287.yz + "\">");
        printWriter.println("<param  name=mapzx value=\"" + this.f287.zx + "\">");
        printWriter.println("<param  name=mapzy value=\"" + this.f287.zy + "\">");
        printWriter.println("<param  name=mapzz value=\"" + this.f287.zz + "\">");
        printWriter.println("<param  name=mapixx value=\"" + this.f287.ixx + "\">");
        printWriter.println("<param  name=mapixy value=\"" + this.f287.ixy + "\">");
        printWriter.println("<param  name=mapixz value=\"" + this.f287.ixz + "\">");
        printWriter.println("<param  name=mapiyx value=\"" + this.f287.iyx + "\">");
        printWriter.println("<param  name=mapiyy value=\"" + this.f287.iyy + "\">");
        printWriter.println("<param  name=mapiyz value=\"" + this.f287.iyz + "\">");
        printWriter.println("<param  name=mapizx value=\"" + this.f287.izx + "\">");
        printWriter.println("<param  name=mapizy value=\"" + this.f287.izy + "\">");
        printWriter.println("<param  name=mapizz value=\"" + this.f287.izz + "\">");
    }

    public final void reset() {
        super.reset();
        this.f289 = 1.0;
        this.f290 = 1.0;
        this.f287 = new Matrix3D();
        this.componentResized(null);
    }

    public final void softReset() {
        super.softReset();
        this.f289 = 1.0;
        this.f290 = 1.0;
        this.f287 = new Matrix3D();
        this.componentResized(null);
    }

    public final void printPS() {
        PSHandler.statement("%Here starts the individual view code");
        PSHandler.statement("gsave");
        PSHandler.clip();
        PSHandler.defBlack(this.pointCT.black.full);
        PSHandler.colorTable(this.pointCT, "Point");
        PSHandler.colorTable(this.lineCT, "Line");
        PSHandler.colorTable(this.polyCT, "Polygon");
        PSHandler.colorTable(this.lociCT, "Locus");
        PSHandler.statement("gsave");
        PSHandler.clipCircle(this.f42.x, this.f42.y, this.f288 + 1);
        PSHandler.background();
        this.elements.recalcPS();
        PSHandler.backModeOn();
        this.elements.printBackPS();
        PSHandler.backModeOff();
        PSHandler.setLineThickness(2.1);
        PSHandler.setColor("black");
        PSHandler.drawCircle(this.f42.x, this.f42.y, this.f288);
        this.elements.printPS();
        PSHandler.statement("grestore");
        PSHandler.statement("grestore");
        PSHandler.statement("%Now printing labels");
        PSHandler.statement("labelFont");
        this.elements.printLabelPS();
        PSHandler.statement("%Here ends the individual view code");
    }

    public final int PSw() {
        return 2 * this.f288;
    }

    public final int PSh() {
        return 2 * this.f288;
    }

    public final int PSxOffset() {
        return this.f288 - this.f42.x;
    }

    public final int PSyOffset() {
        return this.f288 - this.f42.y;
    }
}

