/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGSegment;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Vec;
import de.cinderella.ports.Appearance;
import de.cinderella.ports.PSHandler;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public final class HyperbolicPort
extends ViewPort
implements ComponentListener {
    public int[] f37;
    public int[] f38;
    public int[] f39;
    public int f40;
    public double f41 = 150.0;
    public Point f42 = new Point(200, 200);

    public HyperbolicPort() {
        new Point(200, 200);
        this.pref = new Dimension(400, 400);
    }

    public final ViewPortElement fittingPGElement(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            if (this.polar) {
                return new c90(pGElement, this);
            }
            return new c92(pGElement, this);
        }
        if (pGElement instanceof PGLine) {
            if (this.polar) {
                return new c92(pGElement, this);
            }
            return new c90(pGElement, this);
        }
        if (pGElement instanceof PGSegment) {
            if (this.polar) {
                return new c92(pGElement, this);
            }
            return new c90(pGElement, this);
        }
        if (pGElement instanceof PGConic) {
            return new c29(pGElement, this);
        }
        if (pGElement instanceof PGLocus) {
            return new c94(pGElement, this);
        }
        return null;
    }

    public final void toVec(Point point, Vec vec) {
        this.toVec(point.x, point.y, vec);
    }

    public final void toVec(int n, int n2, Vec vec) {
        double d = (double)(n - this.f42.x) / this.f41;
        double d2 = (double)(n2 - this.f42.y) / this.f41;
        double d3 = d * d + d2 * d2;
        double d4 = d3 < 1.0 ? 2.0 / (d3 + 1.0) : 1.0 / Math.sqrt(d3);
        vec.assign(d * d4, d2 * d4, 1.0);
    }

    public final boolean toPoint(Vec vec, Point point) {
        double d = vec.xr / vec.zr;
        double d2 = vec.yr / vec.zr;
        double d3 = d * d + d2 * d2;
        if (d3 == 0.0) {
            point.move(this.f42.x, this.f42.y);
            return true;
        }
        double d4 = 1.0 / d3;
        double d5 = d4 > 1.0 ? d4 - Math.sqrt(d4 * d4 - d4) : d4 + Math.sqrt(-d4 * d4 + d4);
        point.move((int)(d * d5 * this.f41 + (double)this.f42.x), (int)(d2 * d5 * this.f41 + (double)this.f42.y));
        return d4 > 1.0;
    }

    public final boolean toPoint(Vec vec, DoublePoint doublePoint) {
        double d = vec.xr / vec.zr;
        double d2 = vec.yr / vec.zr;
        double d3 = d * d + d2 * d2;
        if (d3 == 0.0) {
            doublePoint.move(this.f42.x, this.f42.y);
            return true;
        }
        double d4 = 1.0 / d3;
        double d5 = d4 > 1.0 ? d4 - Math.sqrt(d4 * d4 - d4) : d4 + Math.sqrt(-d4 * d4 + d4);
        doublePoint.x = d * d5 * this.f41 + (double)this.f42.x;
        doublePoint.y = d2 * d5 * this.f41 + (double)this.f42.y;
        return d4 > 1.0;
    }

    public final void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.width > 0 && this.height > 0) {
            this.f41 = this.width < this.height ? (int)((double)(this.width / 2) - (double)this.width * 0.07) : (int)((double)(this.height / 2) - (double)this.height * 0.07);
            this.f42.x = this.width / 2;
            this.f42.y = this.height / 2;
            this.f37 = new int[this.height];
            this.f38 = new int[this.height];
            this.f39 = new int[this.height];
            double d = (double)(this.width / 2) - this.f41;
            double d2 = (double)(this.height / 2) - this.f41;
            this.f37[0] = 0;
            this.f38[0] = (int)d2;
            this.f39[0] = this.width;
            this.f40 = 0;
            int n = (int)d2;
            while (n < this.height - (int)d2) {
                double d3 = (double)n - d2 - this.f41;
                ++this.f40;
                double d4 = Math.sqrt(this.f41 * this.f41 - d3 * d3);
                this.f37[this.f40] = (int)(this.f41 + d - d4 + 0.5);
                this.f38[this.f40] = n++;
                this.f39[this.f40] = (int)(this.f41 + d + d4 + 0.5);
            }
            ++this.f40;
            this.f37[this.f40] = 0;
            this.f38[this.f40] = n;
            this.f39[this.f40] = this.width;
            ++this.f40;
            this.elements.resize(this.width, this.height);
            this.elements.forceRecalc();
        }
    }

    private final void m28(Graphics graphics, int n, int n2) {
        double d = (double)(n2 / 2) - this.f41;
        graphics.fillRect(0, 0, n, (int)d);
        graphics.fillRect(0, n2 - (int)d, n, (int)d);
        graphics.fillPolygon(this.f37, this.f38, this.f40);
        graphics.fillPolygon(this.f39, this.f38, this.f40);
    }

    public final void paint(Graphics graphics) {
        if (this.oG == null) {
            this.oG = graphics;
            this.oG.setFont(Appearance.labelfont);
        }
        this.oG.setColor(this.pointCT.background.full);
        this.oG.fillRect(0, 0, this.width, this.height);
        this.elements.recalc();
        this.elements.recalcTmp();
        switch (this.kernel.f33) {
            case 2: {
                this.elements.draft(this.oG);
                break;
            }
            case 1: {
                this.elements.draft(this.oG);
                break;
            }
            case 0: {
                this.elements.draw(this.oG);
            }
        }
        this.oG.setColor(Color.gray);
        this.m28(this.oG, this.width, this.height);
        this.oG.setColor(Color.blue);
        this.oG.drawOval((int)((double)this.f42.x - this.f41), (int)((double)this.f42.y - this.f41), (int)(2.0 * this.f41), (int)(2.0 * this.f41));
        this.elements.drawLabel(this.oG);
        if (this.oI != null) {
            graphics.drawImage(this.oI, 0, 0, this);
            return;
        }
        this.oG = null;
    }

    public final void print(Graphics graphics) {
        graphics.setFont(Appearance.labelfont);
        graphics.setClip(new Rectangle(2, 2, this.width - 4, this.height - 4));
        this.elements.recalc();
        this.elements.recalcTmp();
        this.elements.draw(graphics);
        graphics.setColor(Color.white);
        this.m28(graphics, this.width, this.height);
        graphics.setColor(Color.black);
        graphics.drawOval((int)((double)this.f42.x - this.f41), (int)((double)this.f42.y - this.f41), (int)(2.0 * this.f41), (int)(2.0 * this.f41));
        this.elements.drawLabel(graphics);
    }

    public final void print(PrintJob printJob) {
        int n = printJob.getPageDimension().width - 40;
        int n2 = printJob.getPageDimension().height - 40;
        Graphics graphics = printJob.getGraphics();
        graphics.translate(20, 20);
        graphics.translate((n - this.width) / 2, (n2 - this.height) / 2);
        graphics.setColor(Color.black);
        graphics.setClip(2, 2, this.width - 4, this.height - 4);
        graphics.setFont(Appearance.textfont);
        super.forceRecalc();
        this.elements.draw(graphics);
        graphics.setColor(Color.white);
        this.m28(graphics, this.width, this.height);
        graphics.setColor(Color.black);
        graphics.drawOval((int)((double)this.f42.x - this.f41), (int)((double)this.f42.y - this.f41), (int)(2.0 * this.f41), (int)(2.0 * this.f41));
        this.elements.drawLabel(graphics);
        graphics.dispose();
    }

    public final void printPS() {
        PSHandler.statement("%Here starts the individual view code");
        PSHandler.statement("gsave");
        PSHandler.clip();
        PSHandler.colorTable(this.pointCT, "Point");
        PSHandler.colorTable(this.lineCT, "Line");
        PSHandler.colorTable(this.polyCT, "Polygon");
        PSHandler.colorTable(this.lociCT, "Locus");
        PSHandler.statement("gsave");
        PSHandler.clipCircle(this.f42.x, this.f42.y, this.f41 + 1.0);
        PSHandler.background();
        PSHandler.setLineThickness(2.1);
        PSHandler.setColor("black");
        PSHandler.drawCircle(this.f42.x, this.f42.y, this.f41);
        this.elements.recalcPS();
        this.elements.printPS();
        PSHandler.statement("grestore");
        PSHandler.statement("grestore");
        PSHandler.statement("%Now printing labels");
        PSHandler.statement("labelFont");
        this.elements.printLabelPS();
        PSHandler.statement("%Here ends the individual view code");
    }

    public final int PSw() {
        return (int)(2.0 * this.f41);
    }

    public final int PSh() {
        return (int)(2.0 * this.f41);
    }

    public final int PSxOffset() {
        return (int)this.f41 - this.f42.x;
    }

    public final int PSyOffset() {
        return (int)this.f41 - this.f42.y;
    }
}

