/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.math.Vec;
import de.cinderella.modes.Mode;
import de.cinderella.ports.ViewPort;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class GenericListener
implements MouseListener,
MouseMotionListener {
    public Vec pos = new Vec();
    public transient Cindy kernel;
    public transient boolean mouseDown = false;
    public transient MouseEvent lastEvent;

    public GenericListener(Cindy cindy) {
        this.kernel = cindy;
    }

    public GenericListener() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ViewPort viewPort = (ViewPort)mouseEvent.getSource();
        viewPort.toVecGrid(mouseEvent.getPoint(), this.pos);
        Mode mode = (Mode)this.kernel.f20.value;
        if (!viewPort.polar || mode.allowsPolar) {
            mode.mouseClicked(mouseEvent, this.pos, viewPort, this.kernel);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseDown || mouseEvent.getY() < 0) {
            return;
        }
        ViewPort viewPort = (ViewPort)mouseEvent.getSource();
        this.mouseDown = true;
        viewPort.toVecGrid(mouseEvent.getPoint(), this.pos);
        Mode mode = (Mode)this.kernel.f20.value;
        if (!viewPort.polar || mode.allowsPolar) {
            mode.mousePressed(mouseEvent, this.pos, viewPort, this.kernel);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        if (this.lastEvent != null) {
            this.mouseDragged(this.lastEvent);
        }
        this.mouseDown = false;
        ViewPort viewPort = (ViewPort)mouseEvent.getSource();
        viewPort.toVecGrid(mouseEvent.getPoint(), this.pos);
        Mode mode = (Mode)this.kernel.f20.value;
        if (!viewPort.polar || mode.allowsPolar) {
            mode.mouseReleased(mouseEvent, this.pos, viewPort, this.kernel);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        ViewPort viewPort = (ViewPort)mouseEvent.getSource();
        viewPort.toVecGrid(mouseEvent.getPoint(), this.pos);
        Mode mode = (Mode)this.kernel.f20.value;
        if (!viewPort.polar || mode.allowsPolar) {
            mode.mouseDragged(mouseEvent, this.pos, viewPort, this.kernel);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        ViewPort viewPort = (ViewPort)mouseEvent.getSource();
        viewPort.toVecGrid(mouseEvent.getPoint(), this.pos);
        Mode mode = (Mode)this.kernel.f20.value;
        if (!viewPort.polar || mode.allowsPolar) {
            mode.mouseMoved(mouseEvent, this.pos, viewPort, this.kernel);
        }
    }
}

