/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.math;

import de.cinderella.math.Vec;
import java.io.Serializable;

public final class Matrix3D
implements Serializable {
    public double xx;
    public double xy;
    public double xz;
    public double yx;
    public double yy;
    public double yz;
    public double zx;
    public double zy;
    public double zz;
    public double ixx;
    public double ixy;
    public double ixz;
    public double iyx;
    public double iyy;
    public double iyz;
    public double izx;
    public double izy;
    public double izz;

    public Matrix3D() {
        this.unit();
    }

    public final Matrix3D assign(Matrix3D matrix3D) {
        this.xx = matrix3D.xx;
        this.xy = matrix3D.xy;
        this.xz = matrix3D.xz;
        this.yx = matrix3D.yx;
        this.yy = matrix3D.yy;
        this.yz = matrix3D.yz;
        this.zx = matrix3D.zx;
        this.zy = matrix3D.zy;
        this.zz = matrix3D.zz;
        this.ixx = matrix3D.ixx;
        this.ixy = matrix3D.ixy;
        this.ixz = matrix3D.ixz;
        this.iyx = matrix3D.iyx;
        this.iyy = matrix3D.iyy;
        this.iyz = matrix3D.iyz;
        this.izx = matrix3D.izx;
        this.izy = matrix3D.izy;
        this.izz = matrix3D.izz;
        return this;
    }

    public final boolean equals(Matrix3D matrix3D) {
        return this.xx == matrix3D.xx && this.xy == matrix3D.xy && this.xz == matrix3D.xz && this.yx == matrix3D.yx && this.yy == matrix3D.yy && this.yz == matrix3D.yz && this.zx == matrix3D.zx && this.zy == matrix3D.zy && this.zz == matrix3D.zz && this.ixx == matrix3D.ixx && this.ixy == matrix3D.ixy && this.ixz == matrix3D.ixz && this.iyx == matrix3D.iyx && this.iyy == matrix3D.iyy && this.iyz == matrix3D.iyz && this.izx == matrix3D.izx && this.izy == matrix3D.izy && this.izz == matrix3D.izz;
    }

    public final void yrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.xx * d2 + this.xz * d3;
        double d5 = this.yx * d2 + this.yz * d3;
        double d6 = this.zx * d2 + this.zz * d3;
        double d7 = this.xz * d2 - this.xx * d3;
        double d8 = this.yz * d2 - this.yx * d3;
        double d9 = this.zz * d2 - this.zx * d3;
        this.xx = d4;
        this.yx = d5;
        this.zx = d6;
        this.xz = d7;
        this.yz = d8;
        this.zz = d9;
        double d10 = this.ixx * d2 + this.izx * d3;
        double d11 = this.ixy * d2 + this.izy * d3;
        double d12 = this.ixz * d2 + this.izz * d3;
        double d13 = this.izx * d2 - this.ixx * d3;
        double d14 = this.izy * d2 - this.ixy * d3;
        double d15 = this.izz * d2 - this.ixz * d3;
        this.ixx = d10;
        this.ixy = d11;
        this.ixz = d12;
        this.izx = d13;
        this.izy = d14;
        this.izz = d15;
    }

    public final void xrot(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        double d4 = this.xy * d2 + this.xz * d3;
        double d5 = this.yy * d2 + this.yz * d3;
        double d6 = this.zy * d2 + this.zz * d3;
        double d7 = this.xz * d2 - this.xy * d3;
        double d8 = this.yz * d2 - this.yy * d3;
        double d9 = this.zz * d2 - this.zy * d3;
        this.xy = d4;
        this.yy = d5;
        this.zy = d6;
        this.xz = d7;
        this.yz = d8;
        this.zz = d9;
        double d10 = this.iyx * d2 + this.izx * d3;
        double d11 = this.iyy * d2 + this.izy * d3;
        double d12 = this.iyz * d2 + this.izz * d3;
        double d13 = this.izx * d2 - this.iyx * d3;
        double d14 = this.izy * d2 - this.iyy * d3;
        double d15 = this.izz * d2 - this.iyz * d3;
        this.iyx = d10;
        this.iyy = d11;
        this.iyz = d12;
        this.izx = d13;
        this.izy = d14;
        this.izz = d15;
    }

    public final void unit() {
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
        this.ixx = 1.0;
        this.ixy = 0.0;
        this.ixz = 0.0;
        this.iyx = 0.0;
        this.iyy = 1.0;
        this.iyz = 0.0;
        this.izx = 0.0;
        this.izy = 0.0;
        this.izz = 1.0;
    }

    public final void transform(Vec vec, Vec vec2) {
        vec2.assign(this.xx * vec.xr + this.xy * vec.yr + this.xz * vec.zr, this.yx * vec.xr + this.yy * vec.yr + this.yz * vec.zr, this.zx * vec.xr + this.zy * vec.yr + this.zz * vec.zr);
    }

    public final void inversetfm(Vec vec, Vec vec2) {
        vec2.assign(this.ixx * vec.xr + this.ixy * vec.yr + this.ixz * vec.zr, this.iyx * vec.xr + this.iyy * vec.yr + this.iyz * vec.zr, this.izx * vec.xr + this.izy * vec.yr + this.izz * vec.zr);
    }

    public final String toString() {
        return "[" + this.xx + "," + this.xy + "," + this.xz + ";" + this.yx + "," + this.yy + "," + this.yz + ";" + this.zx + "," + this.zy + "," + this.zz + "]";
    }
}

