/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.geometry;

import de.cinderella.geometry.UndoList;
import de.cinderella.geometry.UndoObject;
import de.cinderella.geometry.UndoWithRefresh;
import de.cinderella.ports.ViewPort;
import java.util.Vector;

public class UndoManager {
    public UndoList undos = new UndoList("Undos");
    public UndoList redos = new UndoList("Redos");

    public final void clear() {
        this.undos.clear();
        this.redos.clear();
    }

    public final boolean undoOne() {
        boolean bl = false;
        if (!this.undos.undos.isEmpty()) {
            UndoObject undoObject = this.undos.getLast();
            UndoObject undoObject2 = undoObject.createRedo();
            bl = this.undos.undoOne();
            this.redos.forceAddUndo(undoObject2);
        }
        return bl;
    }

    public final UndoObject lastUndo() {
        return this.undos.getLast();
    }

    public final boolean redoOne() {
        boolean bl = false;
        if (!this.redos.undos.isEmpty()) {
            UndoObject undoObject = this.redos.getLast();
            UndoObject undoObject2 = undoObject.createRedo();
            bl = this.redos.undoOne();
            this.undos.forceAddUndo(undoObject2);
        }
        return bl;
    }

    public final void addUndo(UndoObject undoObject) {
        if (this.undos.addUndo(undoObject)) {
            this.redos.clear();
        }
    }

    public final void removePort(ViewPort viewPort, UndoList undoList) {
        Vector vector = undoList.undos;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            UndoObject undoObject = (UndoObject)vector.elementAt(n2);
            if (undoObject instanceof UndoList) {
                this.removePort(viewPort, (UndoList)undoObject);
                if (((UndoList)undoObject).undos.isEmpty()) {
                    vector.removeElement(undoObject);
                    --n2;
                    --n;
                }
            }
            if (undoObject instanceof UndoWithRefresh) {
                UndoWithRefresh undoWithRefresh = (UndoWithRefresh)undoObject;
                if (undoWithRefresh.handle == viewPort || undoWithRefresh.refresher == viewPort) {
                    vector.removeElement(undoObject);
                    --n2;
                    --n;
                }
            }
            ++n2;
        }
    }

    public final void removePort(ViewPort viewPort) {
        this.removePort(viewPort, this.undos);
        this.removePort(viewPort, this.redos);
    }
}

