/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.geometry;

import de.cinderella.controls.Intl;
import de.cinderella.controls.ObservableInt;
import de.cinderella.math.Complex;
import de.cinderella.math.Mat;
import de.cinderella.math.Vec;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class PGFormat {
    public static final DecimalFormat df = new DecimalFormat("###.##");
    public static final FieldPosition fp = new FieldPosition(0);
    public static String invalid = " " + Intl.getMessage("formatInvalid");
    public static String horizontal = Intl.getMessage("formatHorizontal");
    public static String vertical = Intl.getMessage("formatVertical");
    public static String infinity = Intl.getMessage("formatInfinity");
    public static ObservableInt circleFormat;
    public static ObservableInt pointFormat;
    public static ObservableInt lineFormat;
    public static ObservableInt angleFormat;
    public static ObservableInt distanceFormat;

    public static void format(StringBuffer stringBuffer, double d, double d2) {
        if (d2 * d2 + d * d < 1.0E-16) {
            stringBuffer.append("0");
            return;
        }
        int n = stringBuffer.length();
        df.format(d, stringBuffer, fp);
        if (stringBuffer.length() == n) {
            stringBuffer.append("0");
        }
        if (d2 * d2 > 1.0E-7) {
            stringBuffer.append(" + i*");
            n = stringBuffer.length();
            df.format(d2, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
        }
    }

    public static void formatTermConstant(StringBuffer stringBuffer, double d, double d2) {
        if (d2 * d2 > 1.0E-7) {
            stringBuffer.append(" + (");
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(" + i*");
            n = stringBuffer.length();
            df.format(d2, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(")");
            return;
        }
        if (d < -1.0E-13) {
            stringBuffer.append(" - ");
            int n = stringBuffer.length();
            df.format(-d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else if (d > 1.0E-13) {
            stringBuffer.append(" + ");
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else {
            stringBuffer.append(" + 0");
        }
    }

    public static void formatTermFactor(StringBuffer stringBuffer, double d, double d2) {
        if (d2 * d2 > 1.0E-7) {
            stringBuffer.append(" + (");
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(" + i*");
            n = stringBuffer.length();
            df.format(d2, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(")*");
            return;
        }
        if (d < -1.0E-13) {
            stringBuffer.append(" - ");
            int n = stringBuffer.length();
            df.format(-d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else if (d > 1.0E-13) {
            stringBuffer.append(" + ");
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else {
            stringBuffer.append(" + 0");
        }
    }

    public static void formatFrontTermFactor(StringBuffer stringBuffer, double d, double d2) {
        if (d2 * d2 > 1.0E-7) {
            stringBuffer.append("(");
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(" + i*");
            n = stringBuffer.length();
            df.format(d2, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(")*");
            return;
        }
        if (d < -1.0E-13) {
            stringBuffer.append("-");
            int n = stringBuffer.length();
            df.format(-d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else if (d > 1.0E-13) {
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else {
            stringBuffer.append("0");
        }
    }

    public static void formatFrontTermConstant(StringBuffer stringBuffer, double d, double d2) {
        if (d2 * d2 > 1.0E-7) {
            stringBuffer.append("(");
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(" + i*");
            n = stringBuffer.length();
            df.format(d2, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(")");
            return;
        }
        if (d < -1.0E-13) {
            stringBuffer.append("-");
            int n = stringBuffer.length();
            df.format(-d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else if (d > 1.0E-13) {
            int n = stringBuffer.length();
            df.format(d, stringBuffer, fp);
            if (stringBuffer.length() == n) {
                stringBuffer.append("0");
                return;
            }
        } else {
            stringBuffer.append("0");
        }
    }

    public static void format(StringBuffer stringBuffer, Complex complex) {
        PGFormat.format(stringBuffer, complex.real, complex.imag);
        if (complex.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatArea(StringBuffer stringBuffer, Complex complex, String string) {
        PGFormat.format(stringBuffer, complex);
        stringBuffer.append(string);
    }

    public static void formatDistance(StringBuffer stringBuffer, Complex complex, String string) {
        PGFormat.format(stringBuffer, complex);
        stringBuffer.append(string);
    }

    public static void formatDistance(StringBuffer stringBuffer, Complex complex) {
        switch (PGFormat.distanceFormat.value) {
            case 0: {
                PGFormat.formatDistance(stringBuffer, complex, "");
                return;
            }
            case 1: {
                PGFormat.formatDistance(stringBuffer, complex, "cm");
                return;
            }
            case 2: {
                PGFormat.formatDistance(stringBuffer, complex, "mm");
                return;
            }
            case 3: {
                PGFormat.formatDistance(stringBuffer, complex, "inch");
                return;
            }
        }
    }

    public static void formatArea(StringBuffer stringBuffer, Complex complex) {
        switch (PGFormat.distanceFormat.value) {
            case 0: {
                PGFormat.formatArea(stringBuffer, complex, "");
                return;
            }
            case 1: {
                PGFormat.formatArea(stringBuffer, complex, "cm\u00b2");
                return;
            }
            case 2: {
                PGFormat.formatArea(stringBuffer, complex, "mm\u00b2");
                return;
            }
            case 3: {
                PGFormat.formatArea(stringBuffer, complex, "inch\u00b2");
                return;
            }
        }
    }

    public static void formatAngleDeg(StringBuffer stringBuffer, Complex complex) {
        PGFormat.format(stringBuffer, complex.real * 180.0 / Math.PI, complex.imag * 180.0 / Math.PI);
        stringBuffer.append("\u00b0");
        if (complex.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatAngleRad(StringBuffer stringBuffer, Complex complex) {
        PGFormat.format(stringBuffer, complex.real, complex.imag);
        if (complex.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatAngle(StringBuffer stringBuffer, Complex complex) {
        switch (PGFormat.angleFormat.value) {
            case 0: {
                PGFormat.formatAngleDeg(stringBuffer, complex);
                return;
            }
            case 1: {
                PGFormat.formatAngleRad(stringBuffer, complex);
                return;
            }
        }
    }

    public static void format(StringBuffer stringBuffer, Vec vec) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = vec.xr;
        double d6 = vec.xi;
        double d7 = -vec.yr;
        double d8 = -vec.yi;
        double d9 = vec.zr;
        double d10 = vec.zi;
        double d11 = d9 * d9 + d10 * d10;
        if (d11 != 0.0) {
            d = (d5 * d9 + d6 * d10) / d11;
            d2 = (-d5 * d10 + d6 * d9) / d11;
            d3 = (d7 * d9 + d8 * d10) / d11;
            d4 = (-d7 * d10 + d8 * d9) / d11;
        }
        stringBuffer.append("(");
        if (d11 != 0.0 && d * d + d2 * d2 + d3 * d3 + d4 * d4 < 10000.0) {
            PGFormat.format(stringBuffer, d, d2);
            stringBuffer.append("|");
            PGFormat.format(stringBuffer, d3, d4);
        } else {
            PGFormat.format(stringBuffer, d5, d6);
            stringBuffer.append(":");
            PGFormat.format(stringBuffer, d7, d8);
            stringBuffer.append(":");
            PGFormat.format(stringBuffer, d9, d10);
        }
        stringBuffer.append(")");
        if (vec.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatLineNormal(StringBuffer stringBuffer, Vec vec) {
        double d = vec.xr;
        double d2 = vec.xi;
        double d3 = -vec.yr;
        double d4 = -vec.yi;
        double d5 = vec.zr;
        double d6 = vec.zi;
        double d7 = Math.sqrt(d * d + d2 * d2 + d3 * d3 + d4 * d4);
        if (d5 > 0.0) {
            d7 *= -1.0;
        }
        if (d7 != 0.0) {
            d /= d7;
            d2 /= d7;
            d3 /= d7;
            d4 /= d7;
            d5 /= d7;
            d6 /= d7;
        }
        if (d7 * d7 < 1.0E-17) {
            stringBuffer.append(infinity);
            return;
        }
        PGFormat.formatFrontTermFactor(stringBuffer, d, d2);
        stringBuffer.append("x ");
        PGFormat.formatTermFactor(stringBuffer, d3, d4);
        stringBuffer.append("y = ");
        PGFormat.formatFrontTermFactor(stringBuffer, -d5, -d6);
        if (vec.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatLineXY(StringBuffer stringBuffer, Vec vec) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = vec.xr;
        double d6 = vec.xi;
        double d7 = -vec.yr;
        double d8 = -vec.yi;
        double d9 = vec.zr;
        double d10 = vec.zi;
        double d11 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7 + d8 * d8);
        if (d11 * d11 < 1.0E-17) {
            stringBuffer.append(infinity);
            if (vec.invalid != 0) {
                stringBuffer.append(invalid);
            }
            return;
        }
        d11 = d7 * d7 + d8 * d8;
        if (d11 != 0.0) {
            d = (d5 * d7 + d6 * d8) / d11;
            d2 = (-d5 * d8 + d6 * d7) / d11;
            d3 = (d9 * d7 + d10 * d8) / d11;
            d4 = (-d9 * d8 + d10 * d7) / d11;
        }
        if (d11 != 0.0) {
            stringBuffer.append("y = ");
            PGFormat.formatFrontTermFactor(stringBuffer, -d, -d2);
            stringBuffer.append("x ");
            PGFormat.formatTermConstant(stringBuffer, -d3, -d4);
        } else {
            stringBuffer.append(vertical);
        }
        if (vec.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatLineYX(StringBuffer stringBuffer, Vec vec) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = vec.xr;
        double d6 = vec.xi;
        double d7 = -vec.yr;
        double d8 = -vec.yi;
        double d9 = vec.zr;
        double d10 = vec.zi;
        double d11 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7 + d8 * d8);
        if (d11 * d11 < 1.0E-17) {
            stringBuffer.append(infinity);
            if (vec.invalid != 0) {
                stringBuffer.append(invalid);
            }
            return;
        }
        d11 = d5 * d5 + d6 * d6;
        if (d11 != 0.0) {
            d = (d7 * d5 + d8 * d6) / d11;
            d2 = (-d7 * d6 + d8 * d5) / d11;
            d3 = (d9 * d5 + d10 * d6) / d11;
            d4 = (-d9 * d6 + d10 * d5) / d11;
        }
        if (d11 != 0.0) {
            stringBuffer.append("x = ");
            PGFormat.formatFrontTermFactor(stringBuffer, -d, -d2);
            stringBuffer.append("y ");
            PGFormat.formatTermConstant(stringBuffer, -d3, -d4);
        } else {
            stringBuffer.append(horizontal);
        }
        if (vec.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatLine(StringBuffer stringBuffer, Vec vec) {
        switch (PGFormat.lineFormat.value) {
            case 0: {
                PGFormat.formatLineNormal(stringBuffer, vec);
                return;
            }
            case 1: {
                PGFormat.formatLineXY(stringBuffer, vec);
                return;
            }
            case 2: {
                PGFormat.formatLineYX(stringBuffer, vec);
                return;
            }
        }
    }

    public static void formatPointXY(StringBuffer stringBuffer, Vec vec) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = vec.xr;
        double d6 = vec.xi;
        double d7 = -vec.yr;
        double d8 = -vec.yi;
        double d9 = vec.zr;
        double d10 = vec.zi;
        double d11 = d9 * d9 + d10 * d10;
        if (d11 != 0.0) {
            d = (d5 * d9 + d6 * d10) / d11;
            d2 = (-d5 * d10 + d6 * d9) / d11;
            d3 = (d7 * d9 + d8 * d10) / d11;
            d4 = (-d7 * d10 + d8 * d9) / d11;
        }
        if (d11 == 0.0 || !(d * d + d2 * d2 + d3 * d3 + d4 * d4 < 10000.0)) {
            PGFormat.formatPointHomo(stringBuffer, vec);
            return;
        }
        stringBuffer.append("(");
        PGFormat.format(stringBuffer, d, d2);
        stringBuffer.append("|");
        PGFormat.format(stringBuffer, d3, d4);
        stringBuffer.append(")");
        if (vec.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatPointHomo(StringBuffer stringBuffer, Vec vec) {
        double d = vec.xr / 4.0;
        double d2 = vec.xi / 4.0;
        double d3 = -vec.yr / 4.0;
        double d4 = -vec.yi / 4.0;
        double d5 = vec.zr / 4.0;
        double d6 = vec.zi / 4.0;
        stringBuffer.append("(");
        PGFormat.format(stringBuffer, d, d2);
        stringBuffer.append(":");
        PGFormat.format(stringBuffer, d3, d4);
        stringBuffer.append(":");
        PGFormat.format(stringBuffer, d5, d6);
        stringBuffer.append(")");
        if (vec.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatPoint(StringBuffer stringBuffer, Vec vec) {
        switch (PGFormat.pointFormat.value) {
            case 0: {
                PGFormat.formatPointHomo(stringBuffer, vec);
                return;
            }
            case 1: {
                PGFormat.formatPointXY(stringBuffer, vec);
                return;
            }
        }
    }

    public static void format(StringBuffer stringBuffer, Mat mat) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = mat.axr;
        double d14 = mat.axi;
        double d15 = mat.byr;
        double d16 = mat.byi;
        double d17 = mat.czr;
        double d18 = mat.czi;
        double d19 = -mat.bxr - mat.ayr;
        double d20 = -mat.bxi - mat.ayi;
        double d21 = mat.cxr + mat.azr;
        double d22 = mat.cxi + mat.azi;
        double d23 = -mat.cyr - mat.bzr;
        double d24 = -mat.cyi - mat.bzi;
        double d25 = d17 * d17 + d18 * d18;
        double d26 = d18;
        double d27 = d17;
        if (d25 < 1.0E-14) {
            d25 = d13 * d13 + d14 * d14;
            d26 = d14;
            d27 = d13;
        }
        if (d25 < 1.0E-14) {
            d25 = d15 * d15 + d16 * d16;
            d26 = d16;
            d27 = d15;
        }
        if (d25 < 1.0E-14) {
            d25 = d19 * d19 + d20 * d20;
            d26 = d20;
            d27 = d19;
        }
        if (d25 < 1.0E-14) {
            d25 = 1.0;
        }
        if (d25 != 0.0) {
            d = (d13 * d27 + d14 * d26) / d25;
            d2 = (-d13 * d26 + d14 * d27) / d25;
            d3 = (d15 * d27 + d16 * d26) / d25;
            d4 = (-d15 * d26 + d16 * d27) / d25;
            d5 = (d17 * d27 + d18 * d26) / d25;
            d6 = (-d17 * d26 + d18 * d27) / d25;
            d7 = (d19 * d27 + d20 * d26) / d25;
            d8 = (-d19 * d26 + d20 * d27) / d25;
            d9 = (d21 * d27 + d22 * d26) / d25;
            d10 = (-d21 * d26 + d22 * d27) / d25;
            d11 = (d23 * d27 + d24 * d26) / d25;
            d12 = (-d23 * d26 + d24 * d27) / d25;
        }
        PGFormat.formatFrontTermFactor(stringBuffer, d, d2);
        stringBuffer.append("x\u00b2 ");
        PGFormat.formatTermFactor(stringBuffer, d3, d4);
        stringBuffer.append("y\u00b2 ");
        PGFormat.formatTermFactor(stringBuffer, d7, d8);
        stringBuffer.append("xy ");
        PGFormat.formatTermFactor(stringBuffer, d9, d10);
        stringBuffer.append("x ");
        PGFormat.formatTermFactor(stringBuffer, d11, d12);
        stringBuffer.append("y ");
        PGFormat.formatTermFactor(stringBuffer, d5, d6);
        stringBuffer.append(" = 0");
        if (mat.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatCircleMP(StringBuffer stringBuffer, Mat mat) {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = mat.axr;
        double d16 = mat.axi;
        double d17 = mat.byr;
        double d18 = mat.byi;
        double d19 = mat.czr;
        double d20 = mat.czi;
        double d21 = -mat.bxr - mat.ayr;
        double d22 = -mat.bxi - mat.ayi;
        double d23 = mat.cxr + mat.azr;
        double d24 = mat.cxi + mat.azi;
        double d25 = -mat.cyr - mat.bzr;
        double d26 = -mat.cyi - mat.bzi;
        double d27 = d15 * d15 + d16 * d16;
        double d28 = d16;
        double d29 = d15;
        if (d27 < 1.0E-14) {
            PGFormat.format(stringBuffer, mat);
            return;
        }
        if (d27 != 0.0) {
            d3 = (d15 * d29 + d16 * d28) / d27;
            d4 = (-d15 * d28 + d16 * d29) / d27;
            d5 = (d17 * d29 + d18 * d28) / d27;
            d6 = (-d17 * d28 + d18 * d29) / d27;
            d7 = (d19 * d29 + d20 * d28) / d27;
            d8 = (-d19 * d28 + d20 * d29) / d27;
            d9 = (d21 * d29 + d22 * d28) / d27;
            d10 = (-d21 * d28 + d22 * d29) / d27;
            d11 = (d23 * d29 + d24 * d28) / d27;
            d12 = (-d23 * d28 + d24 * d29) / d27;
            d13 = (d25 * d29 + d26 * d28) / d27;
            d14 = (-d25 * d28 + d26 * d29) / d27;
        }
        double d30 = -d11 / 2.0;
        double d31 = -d12 / 2.0;
        double d32 = -d13 / 2.0;
        double d33 = -d14 / 2.0;
        double d34 = d30 * d30 - d31 * d31 + d32 * d32 - d33 * d33 - d7;
        double d35 = 2.0 * d30 * d31 + 2.0 * d32 * d33 - d8;
        if (d35 * d35 < 1.0E-13) {
            d2 = Math.sqrt(d34);
            d = 0.0;
        } else {
            double d36 = Math.sqrt(Math.sqrt(d34 * d34 + d35 * d35));
            double d37 = Math.atan2(d35, d34);
            d = d36 * Math.sin(d37 / 2.0);
            d2 = d36 * Math.cos(d37 / 2.0);
        }
        stringBuffer.append("(x ");
        PGFormat.formatTermConstant(stringBuffer, -d30, -d31);
        stringBuffer.append(")\u00b2 + (y ");
        PGFormat.formatTermConstant(stringBuffer, -d32, -d33);
        stringBuffer.append(")\u00b2 = ");
        PGFormat.formatFrontTermConstant(stringBuffer, d2, d);
        stringBuffer.append("\u00b2");
        if (mat.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatCircleEqu(StringBuffer stringBuffer, Mat mat) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = mat.axr;
        double d14 = mat.axi;
        double d15 = mat.byr;
        double d16 = mat.byi;
        double d17 = mat.czr;
        double d18 = mat.czi;
        double d19 = -mat.bxr - mat.ayr;
        double d20 = -mat.bxi - mat.ayi;
        double d21 = mat.cxr + mat.azr;
        double d22 = mat.cxi + mat.azi;
        double d23 = -mat.cyr - mat.bzr;
        double d24 = -mat.cyi - mat.bzi;
        double d25 = d13 * d13 + d14 * d14;
        double d26 = d14;
        double d27 = d13;
        if (d25 < 1.0E-14) {
            PGFormat.format(stringBuffer, mat);
            return;
        }
        if (d25 != 0.0) {
            d = (d13 * d27 + d14 * d26) / d25;
            d2 = (-d13 * d26 + d14 * d27) / d25;
            d3 = (d15 * d27 + d16 * d26) / d25;
            d4 = (-d15 * d26 + d16 * d27) / d25;
            d5 = (d17 * d27 + d18 * d26) / d25;
            d6 = (-d17 * d26 + d18 * d27) / d25;
            d7 = (d19 * d27 + d20 * d26) / d25;
            d8 = (-d19 * d26 + d20 * d27) / d25;
            d9 = (d21 * d27 + d22 * d26) / d25;
            d10 = (-d21 * d26 + d22 * d27) / d25;
            d11 = (d23 * d27 + d24 * d26) / d25;
            d12 = (-d23 * d26 + d24 * d27) / d25;
        }
        stringBuffer.append("x\u00b2 + y\u00b2");
        PGFormat.formatTermFactor(stringBuffer, d9, d10);
        stringBuffer.append("x ");
        PGFormat.formatTermFactor(stringBuffer, d11, d12);
        stringBuffer.append("y ");
        PGFormat.formatTermConstant(stringBuffer, d5, d6);
        stringBuffer.append(" = 0");
        if (mat.invalid != 0) {
            stringBuffer.append(invalid);
        }
    }

    public static void formatCircle(StringBuffer stringBuffer, Mat mat) {
        switch (PGFormat.circleFormat.value) {
            case 0: {
                PGFormat.formatCircleEqu(stringBuffer, mat);
                return;
            }
            case 1: {
                PGFormat.formatCircleMP(stringBuffer, mat);
                return;
            }
        }
    }

    static {
        new StringBuffer(20);
        circleFormat = new ObservableInt("circleFormat", 1, true);
        pointFormat = new ObservableInt("pointFormat", 1, true);
        lineFormat = new ObservableInt("lineFormat", 1, true);
        angleFormat = new ObservableInt("angleFormat", 0, true);
        distanceFormat = new ObservableInt("distanceFormat", 0, true);
    }
}

