/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.Cindy;
import de.cinderella.controls.EasyLayout;
import de.cinderella.controls.ImageButton;
import de.cinderella.controls.Intl;
import de.cinderella.controls.LWLabel;
import de.cinderella.controls.MessageDialog;
import de.cinderella.controls.OnlyDigits;
import de.cinderella.controls.ResourceImage;
import de.cinderella.controls.WindowCloser;
import de.cinderella.geometry.Hint;
import de.cinderella.ports.Appearance;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public final class HintEditor
extends Dialog
implements ActionListener,
TextListener {
    public Cindy kernel;
    public Hint myHint;
    public LWLabel nameLabel;
    public LWLabel waitBeforeLabel;
    public LWLabel waitAfterLabel;
    public TextArea preTextArea;
    public TextField nameField;
    public TextField waitBeforeField;
    public TextArea elementArea;
    public TextArea elementHintTextArea;
    public TextArea successTextArea;
    public TextField waitAfterField;
    public ImageButton getButton;
    public ImageButton setButton;
    public ImageButton deleteButton;
    public boolean solution;

    public HintEditor(Cindy cindy, Hint hint) {
        super(ResourceImage.frame);
        this.myHint = hint;
        this.myHint.f178 = this;
        this.solution = this.myHint.f192 == -1;
        this.kernel = cindy;
        this.setLayout(new EasyLayout());
        this.setModal(false);
        this.setTitle(Intl.getMessage(this.solution ? "solTitle" : "hintTitle"));
        ((Component)this).setFont(Appearance.helvetica);
        this.nameLabel = new LWLabel(Intl.getMessage(this.solution ? "nameSol" : "nameHint"));
        this.nameField = new TextField(this.myHint.f185, 20);
        this.nameField.addTextListener(this);
        this.preTextArea = new TextArea(this.myHint.f186, 3, 40, 1);
        this.waitBeforeLabel = new LWLabel(Intl.getMessage(this.solution ? "waitBeforeS" : "waitBeforeH"));
        this.waitBeforeField = new TextField(String.valueOf(this.myHint.f181), 2);
        this.waitBeforeField.addTextListener(OnlyDigits.instance);
        this.waitBeforeField.addKeyListener(OnlyDigits.instance);
        this.elementArea = new TextArea(Intl.getMessage(this.solution ? "elementsS" : "elementsH"), 2, 40, 1);
        this.elementArea.setEditable(false);
        this.elementHintTextArea = new TextArea(this.myHint.f188, 3, 40, 1);
        this.successTextArea = new TextArea(this.myHint.f189, 3, 40, 1);
        if (!this.solution) {
            this.waitAfterLabel = new LWLabel(Intl.getMessage("waitAfter"));
            this.waitAfterField = new TextField(String.valueOf(this.myHint.f192), 2);
            this.waitAfterField.addTextListener(OnlyDigits.instance);
            this.waitAfterField.addKeyListener(OnlyDigits.instance);
        }
        this.getButton = new ImageButton(Intl.getMessage("getSelection"));
        this.getButton.addActionListener(this);
        this.setButton = new ImageButton(Intl.getMessage("setSelection"));
        this.setButton.addActionListener(this);
        this.deleteButton = new ImageButton(Intl.getMessage("delete" + (this.solution ? "Solution" : "Hint")));
        this.deleteButton.addActionListener(this);
        this.addNotify();
        this.add("c", this.nameLabel);
        this.add("+c+n", this.nameField);
        this.add("+cn", this.preTextArea);
        this.add("c", this.waitBeforeLabel);
        this.add("+c+n", this.waitBeforeField);
        this.add("+cn", this.elementHintTextArea);
        this.add("+cn", this.elementArea);
        if (!this.solution) {
            this.add("c", this.waitAfterLabel);
            this.add("+c+n", this.waitAfterField);
        }
        this.add("+cn", this.successTextArea);
        this.add("*c*", this.getButton);
        this.add("c*", this.setButton);
        this.add("c*n", this.deleteButton);
        this.pack();
        this.updateHint();
        this.addWindowListener(WindowCloser.hide);
        this.setResizable(false);
    }

    public final void updateHint() {
        ((TextComponent)this.nameField).setText(this.myHint.f185);
        this.elementArea.setText(String.valueOf(Intl.getMessage(this.solution ? "elementsS" : "elementsH")) + this.myHint.f182.toString());
        this.repaint();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        if (object == this.getButton) {
            this.myHint.f182 = this.kernel.f15.pgelements.getSelection();
        }
        if (object == this.setButton) {
            this.myHint.f182.select();
            this.kernel.f17.redrawLater();
        }
        if (object == this.deleteButton && (n = MessageDialog.show2ButtonDialog("delete" + (this.solution ? "Solution" : "Hint") + "Title", "delete" + (this.solution ? "Solution" : "Hint") + "Msg", "OK", "cancel")) == 0) {
            if (this.solution) {
                this.kernel.f24.f184.removeElement(this.myHint);
                this.kernel.f24.f178.updateExercise();
            } else {
                this.kernel.f24.f183.removeElement(this.myHint);
                this.kernel.f24.f178.updateExercise();
            }
            this.dispose();
        }
        this.updateHint();
    }

    public final void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.nameField) {
            this.myHint.f185 = this.nameField.getText();
            this.kernel.f24.f178.updateExercise();
        }
    }

    public final int getWaitBefore() {
        return new Integer(this.waitBeforeField.getText());
    }

    public final int getWaitAfter() {
        return new Integer(this.waitAfterField.getText());
    }

    public final String getPreText() {
        return this.preTextArea.getText();
    }

    public final String getSuccessText() {
        return this.successTextArea.getText();
    }

    public final String getElementHintText() {
        return this.elementHintTextArea.getText();
    }
}

