/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.Cindy;
import de.cinderella.controls.EasyLayout;
import de.cinderella.controls.ExerciseEditor$1;
import de.cinderella.controls.FileOps;
import de.cinderella.controls.HintEditor;
import de.cinderella.controls.ImageButton;
import de.cinderella.controls.InputEditor;
import de.cinderella.controls.Intl;
import de.cinderella.controls.LWLabel;
import de.cinderella.controls.MessageDialog;
import de.cinderella.controls.ResourceImage;
import de.cinderella.controls.WindowCloser;
import de.cinderella.geometry.Hint;
import de.cinderella.geometry.PGElement;
import de.cinderella.ports.Appearance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

public final class ExerciseEditor
extends Dialog
implements ActionListener {
    public Cindy kernel;
    public LWLabel inputLabel;
    public List inputList;
    public LWLabel hintLabel;
    public List hintList;
    public LWLabel solutionLabel;
    public List solutionList;
    public ImageButton newHintButton;
    public ImageButton newSolutionButton;
    public ImageButton exportButton;
    public ImageButton editButton;

    public ExerciseEditor(Cindy cindy) {
        super(ResourceImage.frame);
        this.kernel = cindy;
        cindy.f24.f178 = this;
        this.setLayout(new EasyLayout());
        this.setModal(false);
        ExerciseEditor$1 exerciseEditor$1 = new ExerciseEditor$1();
        this.setTitle(Intl.getMessage("exerciseTitle"));
        ((Component)this).setFont(Appearance.helvetica);
        this.inputLabel = new LWLabel(Intl.getMessage("exInTi"));
        this.inputList = new List(1, false);
        this.hintLabel = new LWLabel(Intl.getMessage("exHiTi"));
        this.hintList = new List(4, false);
        this.solutionLabel = new LWLabel(Intl.getMessage("exSoTi"));
        this.solutionList = new List(4, false);
        this.inputList.addFocusListener(exerciseEditor$1);
        this.inputList.setBackground(Color.white);
        this.inputList.setForeground(Color.blue);
        this.inputList.addActionListener(this);
        this.hintList.addFocusListener(exerciseEditor$1);
        this.hintList.setBackground(Color.white);
        this.hintList.setForeground(Color.blue);
        this.hintList.addActionListener(this);
        this.solutionList.addFocusListener(exerciseEditor$1);
        this.solutionList.setBackground(Color.white);
        this.solutionList.setForeground(Color.blue);
        this.solutionList.addActionListener(this);
        this.addWindowListener(WindowCloser.hide);
        this.newHintButton = new ImageButton(Intl.getMessage("newHint"));
        this.newHintButton.addActionListener(this);
        this.newSolutionButton = new ImageButton(Intl.getMessage("newSolu"));
        this.newSolutionButton.addActionListener(this);
        this.editButton = new ImageButton(Intl.getMessage("exEdit"));
        this.editButton.addActionListener(this);
        this.exportButton = new ImageButton(Intl.modenames.getString("exportAnimation"), Intl.icons.getString("exportAnimation"));
        this.exportButton.addActionListener(this);
        this.addNotify();
        this.add("cn", this.inputLabel);
        this.add("+cn", this.inputList);
        this.add("c", this.hintLabel);
        this.add("*c+n", this.newHintButton);
        this.add("+cn", this.hintList);
        this.add("c", this.solutionLabel);
        this.add("*c+n", this.newSolutionButton);
        this.add("+cn", this.solutionList);
        this.add("*c*", this.editButton);
        this.add("c*n", this.exportButton);
        this.pack();
        this.setResizable(false);
        this.show();
    }

    public final void updateExercise() {
        this.inputList.removeAll();
        this.inputList.addItem(this.kernel.f24.f185);
        this.hintList.removeAll();
        Vector vector = this.kernel.f24.f183;
        int n = 0;
        while (n < vector.size()) {
            Hint hint = (Hint)vector.elementAt(n);
            this.hintList.addItem(hint.f185);
            ++n;
        }
        this.solutionList.removeAll();
        vector = this.kernel.f24.f184;
        int n2 = 0;
        while (n2 < vector.size()) {
            Hint hint = (Hint)vector.elementAt(n2);
            this.solutionList.addItem(hint.f185);
            ++n2;
        }
        this.repaint();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        Hint hint;
        Object object = actionEvent.getSource();
        if (object == this.newSolutionButton) {
            hint = new Hint(this.kernel, true, this.solutionList.getItemCount() + 1);
            this.kernel.f24.f184.addElement(hint);
            this.solutionList.addItem(hint.f185);
            this.solutionList.select(this.solutionList.getItemCount() - 1);
            this.hintList.deselect(this.hintList.getSelectedIndex());
            this.repaint();
        }
        if (object == this.newHintButton) {
            hint = new Hint(this.kernel, false, this.hintList.getItemCount() + 1);
            this.kernel.f24.f183.addElement(hint);
            this.hintList.addItem(hint.f185);
            this.hintList.select(this.hintList.getItemCount() - 1);
            this.solutionList.deselect(this.solutionList.getSelectedIndex());
            this.repaint();
        }
        if (object == this.editButton || object == this.hintList || object == this.solutionList || object == this.inputList) {
            if (this.inputList.getSelectedIndex() != -1 || object == this.inputList) {
                if (this.kernel.f24.f179 == null) {
                    new InputEditor(this.kernel);
                }
                this.kernel.f24.f179.show();
            } else if (this.hintList.getSelectedIndex() != -1) {
                hint = (Hint)this.kernel.f24.f183.elementAt(this.hintList.getSelectedIndex());
                if (hint.f178 == null) {
                    hint.f178 = new HintEditor(this.kernel, hint);
                }
                hint.f178.show();
            } else if (this.solutionList.getSelectedIndex() != -1) {
                hint = (Hint)this.kernel.f24.f184.elementAt(this.solutionList.getSelectedIndex());
                if (hint.f178 == null) {
                    hint.f178 = new HintEditor(this.kernel, hint);
                }
                hint.f178.show();
            }
        }
        if (object == this.exportButton) {
            int n = this.kernel.f24.m74();
            if (n == 0) {
                switch (FileOps.saveBefore("exportExercise", this.kernel)) {
                    case 0: {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    case 1: {
                        File file;
                        if (this.kernel.f15.filename == null) {
                            this.kernel.f15.filename = FileOps.defaultSaveFile;
                        }
                        if ((file = FileOps.showSaveDialog(".html", ".htm")) == null) {
                            return;
                        }
                        this.kernel.f26 = true;
                        FileOps.writeHTML(this.kernel, file);
                        this.kernel.f26 = false;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            MessageDialog.showMessage("badExerciseTitle" + n, "badExerciseMsg" + n);
        }
    }

    public final void labelChange(PGElement pGElement) {
        if (this.kernel.f24.f179 != null) {
            this.kernel.f24.f179.updateInput();
        }
        Vector vector = this.kernel.f24.f183;
        int n = 0;
        while (n < vector.size()) {
            HintEditor hintEditor = ((Hint)vector.elementAt((int)n)).f178;
            hintEditor.updateHint();
            ++n;
        }
        vector = this.kernel.f24.f184;
        int n2 = 0;
        while (n2 < vector.size()) {
            HintEditor hintEditor = ((Hint)vector.elementAt((int)n2)).f178;
            hintEditor.updateHint();
            ++n2;
        }
    }
}

