/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.algorithms;

import de.cinderella.algorithms.Movable;
import de.cinderella.algorithms.TooCloseException;
import de.cinderella.controls.Intl;
import de.cinderella.geometry.Geometry;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGFlat;
import de.cinderella.geometry.Program;
import de.cinderella.math.Complex;
import de.cinderella.math.Vec;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;

public abstract class Algorithm {
    public Geometry geo;
    public boolean mark;
    public boolean done;
    public transient int changed = -1;
    public Program program;
    public PGElement[] output;
    public PGElement[] input = new PGElement[0];
    public static final Vec[] ref = new Vec[]{new Vec(1.0, 0.0, 0.0), new Vec(0.0, 1.0, 0.0), new Vec(0.0, 0.0, 1.0), new Vec(1.0, 1.0, 0.0), new Vec(1.0, 0.0, 1.0), new Vec(0.0, 1.0, 1.0), new Vec(1.0, 1.0, 1.0)};

    public void setProgram(Program program) {
        this.program = program;
    }

    public void setInput(PGElement[] pGElementArray) {
        this.input = (PGElement[])pGElementArray.clone();
    }

    public final boolean setInput(Vector vector) {
        int n = vector.size() - this.extraData();
        PGElement[] pGElementArray = new PGElement[n];
        int n2 = 0;
        while (n2 < n) {
            pGElementArray[n2] = (PGElement)vector.elementAt(n2);
            if (pGElementArray[n2] == null) {
                return false;
            }
            ++n2;
        }
        this.setInput(pGElementArray);
        Vector vector2 = new Vector();
        int n3 = n;
        while (n3 < n + this.extraData()) {
            vector2.addElement(vector.elementAt(n3));
            ++n3;
        }
        this.readParameters(vector2);
        return true;
    }

    public final void setLabels(Vector vector, Vec vec) {
        PGElement[] pGElementArray = new PGElement[this.output.length];
        int n = this.output.length;
        int n2 = 0;
        while (n2 < n) {
            pGElementArray[n2] = this.output[n2];
            ++n2;
        }
        if (vec == null) {
            vec = new Vec(1.0, 0.0, 0.0);
        }
        try {
            this.heapsort(vec, pGElementArray);
        }
        catch (TooCloseException tooCloseException) {}
        int n3 = 0;
        while (n3 < n) {
            pGElementArray[n3].f8 = (String)vector.elementAt(n3);
            ++n3;
        }
    }

    public final void setLabels(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.output[n2].f8 = (String)vector.elementAt(n2);
            ++n2;
        }
    }

    public int extraData() {
        return 0;
    }

    public final PGElement[] getOutput() {
        return this.output;
    }

    public void readParameters(Vector vector) {
    }

    public void storeData() {
    }

    public abstract PGElement[] createOutput();

    public void reset() {
    }

    public abstract void recalc();

    private final double dist(Vec vec, PGElement pGElement) {
        if (pGElement instanceof PGFlat) {
            Complex complex = new Complex();
            return complex.scalarProductConjugate(vec, ((PGFlat)pGElement).f127).abs2();
        }
        if (pGElement instanceof PGConic) {
            return vec.mul(((PGConic)pGElement).f125).norm();
        }
        return 1.0;
    }

    private final void swap(PGElement[] pGElementArray, int n, int n2) {
        PGElement pGElement = pGElementArray[n];
        pGElementArray[n] = pGElementArray[n2];
        pGElementArray[n2] = pGElement;
    }

    private final double compare(Vec vec, PGElement[] pGElementArray, int n, int n2) throws TooCloseException {
        double d = this.dist(vec, pGElementArray[n2]) - this.dist(vec, pGElementArray[n]);
        if (Math.abs(d) < 0.1 && !pGElementArray[n2].almostEquals(pGElementArray[n])) {
            throw new TooCloseException(d);
        }
        return d;
    }

    private final void siftDown(Vec vec, PGElement[] pGElementArray, int n, int n2) throws TooCloseException {
        if (2 * n + 1 < n2) {
            if (this.compare(vec, pGElementArray, n, 2 * n + 1) < 0.0) {
                if (2 * n + 2 < n2 && this.compare(vec, pGElementArray, 2 * n + 2, 2 * n + 1) > 0.0) {
                    this.swap(pGElementArray, n, 2 * n + 2);
                    this.siftDown(vec, pGElementArray, 2 * n + 2, n2);
                    return;
                }
                this.swap(pGElementArray, n, 2 * n + 1);
                this.siftDown(vec, pGElementArray, 2 * n + 1, n2);
                return;
            }
            if (2 * n + 2 < n2 && this.compare(vec, pGElementArray, 2 * n + 2, n) > 0.0) {
                this.swap(pGElementArray, n, 2 * n + 2);
                this.siftDown(vec, pGElementArray, 2 * n + 2, n2);
            }
        }
    }

    private final void heapsort(Vec vec, PGElement[] pGElementArray) throws TooCloseException {
        int n = pGElementArray.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            this.siftDown(vec, pGElementArray, n2, n);
            --n2;
        }
        n2 = n - 1;
        while (n2 > 0) {
            this.swap(pGElementArray, 0, n2);
            this.siftDown(vec, pGElementArray, 0, n2);
            --n2;
        }
    }

    public void write(PrintWriter printWriter) {
        int n;
        PGElement[] pGElementArray = new PGElement[this.output.length];
        int n2 = 0;
        while (n2 < this.output.length) {
            pGElementArray[n2] = this.output[n2];
            ++n2;
        }
        Vec vec = null;
        if (this.needsSort()) {
            n = 0;
            int n3 = 0;
            vec = ref[0];
            Random random = new Random();
            while (n == 0) {
                try {
                    this.heapsort(vec, pGElementArray);
                    n = 1;
                }
                catch (TooCloseException tooCloseException) {
                    vec = ++n3 < ref.length ? ref[n3] : new Vec(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
                }
            }
        }
        printWriter.println(String.valueOf(this.toString(pGElementArray, vec)) + ";");
        n = 0;
        while (n < this.output.length) {
            if (this.output[n].f8 != null) {
                this.output[n].m8(printWriter);
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        int n = 0;
        while (n < this.output.length) {
            stringBuffer.append(this.output[n].toString());
            if (n < this.output.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(">:=");
        String string = this.getClass().getName();
        stringBuffer.append(string.substring(string.lastIndexOf(".") + 1));
        stringBuffer.append("(");
        Vector<PGElement> vector = new Vector<PGElement>();
        int n2 = 0;
        while (n2 < this.input.length) {
            vector.addElement(this.input[n2]);
            ++n2;
        }
        this.extraParameters(vector);
        int n3 = 0;
        while (n3 < vector.size()) {
            stringBuffer.append(vector.elementAt(n3));
            if (n3 < vector.size() - 1) {
                stringBuffer.append(',');
            }
            ++n3;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final String toString(PGElement[] pGElementArray, Vec vec) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.needsSort() ? (char)'{' : '(');
        int n = 0;
        while (n < pGElementArray.length) {
            stringBuffer.append(pGElementArray[n].toString());
            if (n < pGElementArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        if (vec != null) {
            stringBuffer.append(",");
            stringBuffer.append(vec);
        }
        stringBuffer.append(this.needsSort() ? (char)'}' : ')');
        stringBuffer.append(":=");
        String string = this.getClass().getName();
        stringBuffer.append(string.substring(string.lastIndexOf(".") + 1));
        stringBuffer.append("(");
        Vector<PGElement> vector = new Vector<PGElement>();
        int n2 = 0;
        while (n2 < this.input.length) {
            vector.addElement(this.input[n2]);
            ++n2;
        }
        this.extraParameters(vector);
        int n3 = 0;
        while (n3 < vector.size()) {
            stringBuffer.append(vector.elementAt(n3));
            if (n3 < vector.size() - 1) {
                stringBuffer.append(',');
            }
            ++n3;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void extraParameters(Vector vector) {
    }

    public final String printName() {
        return Intl.getMessage(this.getClass().getName());
    }

    public String printParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.input.length) {
            stringBuffer.append(this.input[n].m0());
            if (n < this.input.length - 1) {
                stringBuffer.append(";");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toPrintString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        int n = 0;
        while (n < this.output.length) {
            stringBuffer.append(this.output[n].toString());
            if (n < this.output.length - 1) {
                stringBuffer.append(";");
            }
            ++n;
        }
        stringBuffer.append(">:=");
        String string = this.getClass().getName();
        stringBuffer.append(string.substring(string.lastIndexOf(".") + 1));
        stringBuffer.append("(");
        int n2 = 0;
        while (n2 < this.input.length) {
            stringBuffer.append(this.input[n2]);
            if (n2 < this.input.length - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append(")");
        if (this instanceof Movable && this.output[0] instanceof PGFlat) {
            stringBuffer.append(" == ");
            stringBuffer.append(((PGFlat)this.output[0]).f127.toPrintString());
        }
        return stringBuffer.toString();
    }

    public void register() {
        int n = this.output.length;
        int n2 = 0;
        while (n2 < n) {
            this.output[n2].register(this.program.register);
            ++n2;
        }
    }

    public void unregister() {
        int n = this.output.length;
        int n2 = 0;
        while (n2 < n) {
            this.output[n2].unregister(this.program.register);
            ++n2;
        }
    }

    public void debug() {
        int n = this.output.length;
        System.err.println("debug:-------");
        int n2 = 0;
        while (n2 < n) {
            if (this.output[n2] instanceof PGFlat) {
                PGFlat pGFlat = (PGFlat)this.output[n2];
                System.err.println(String.valueOf(pGFlat) + ": " + pGFlat.f127.toPrintString());
            }
            ++n2;
        }
    }

    public int trace() {
        return 0;
    }

    public int needsTrace() {
        return 0;
    }

    public void getConjectures(Vector vector, PGElement pGElement) {
    }

    public final boolean needsSort() {
        return this.output.length > 1;
    }

    public void storeActual() {
    }

    public void store() {
    }
}

