/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRException;
import antlr.Token;
import antlr.collections.impl.BitSet;
import de.cinderella.geometry.PGLabelPos;

public class MismatchedTokenException
extends ANTLRException {
    public String[] tokenNames;
    public Token token;
    public String tokenText;
    public int mismatchType;
    public int expecting;
    public int upper;
    public BitSet set;

    public MismatchedTokenException() {
        super("Mismatched Token: expecting any AST node", (PGLabelPos)null);
    }

    public MismatchedTokenException(String[] stringArray, Token token, int n, boolean bl) {
        super("Mismatched Token", (PGLabelPos)null);
        this.tokenNames = stringArray;
        this.token = token;
        this.tokenText = this.token.getText();
        this.expecting = n;
        this.mismatchType = bl ? 2 : 1;
    }

    private final String tokenName(int n) {
        if (n == 0) {
            return "<Set of tokens>";
        }
        if (n < 0 || n >= this.tokenNames.length) {
            return "<" + String.valueOf(n) + ">";
        }
        return this.tokenNames[n];
    }

    public final String toString() {
        String string = this.token == null ? "" : "line(" + this.token.getLine() + "), ";
        switch (this.mismatchType) {
            case 1: {
                string = String.valueOf(string) + "expecting " + this.tokenName(this.expecting) + ", found '" + this.tokenText + "'";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "expecting anything but " + this.tokenName(this.expecting) + "; got it anyway";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "expecting token in range: " + this.tokenName(this.expecting) + ".." + this.tokenName(this.upper) + ", found '" + this.tokenText + "'";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "expecting token NOT in range: " + this.tokenName(this.expecting) + ".." + this.tokenName(this.upper) + ", found '" + this.tokenText + "'";
                break;
            }
            case 5: 
            case 6: {
                string = String.valueOf(string) + "expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (";
                int[] nArray = this.set.toArray();
                int n = 0;
                while (n < nArray.length) {
                    string = String.valueOf(string) + " ";
                    string = String.valueOf(string) + this.tokenName(nArray[n]);
                    ++n;
                }
                string = String.valueOf(string) + "), found '" + this.tokenText + "'";
                break;
            }
            default: {
                string = super.toString();
            }
        }
        return string;
    }
}

