/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.controls.Intl;
import de.cinderella.controls.Preferences;
import de.cinderella.geometry.PGAngle;
import de.cinderella.geometry.PGArea;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGDistance;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.geometry.PGText;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Vec;
import de.cinderella.ports.TextAngle;
import de.cinderella.ports.TextConic;
import de.cinderella.ports.TextDistance;
import de.cinderella.ports.TextElement;
import de.cinderella.ports.TextLine;
import de.cinderella.ports.TextPoint;
import de.cinderella.ports.TextPolygon;
import de.cinderella.ports.TextPortListener;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Observer;

public class TextPort
extends ViewPort
implements ComponentListener,
Observer {
    public static Font textViewFont = Preferences.getFont("cinderella.textview.font");
    public static FontMetrics textViewFM = Toolkit.getDefaultToolkit().getFontMetrics(textViewFont);
    public static int textViewA = textViewFM.getAscent();
    public static int textViewD = textViewFM.getDescent();
    public int bStart = 20;
    public int bLabel = 50;
    public int bAlg = 150;
    public int bCoord = 1000;
    public int posLabel;
    public int posAlg;
    public int posCoord;
    public double slifact;
    public int xoff;
    public int head;
    public int yoff = this.head = textViewA + textViewD + 10;
    public int slitop;
    public int slibot;
    public int top;
    public int bot;
    public int show;
    public int all;

    public TextPort() {
        Dimension dimension = this.pref = new Dimension(400, 400);
        this.width = dimension.width;
        this.height = dimension.height;
        this.reset();
    }

    public final ViewPortElement fittingPGElement(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            return new TextPoint(pGElement, this);
        }
        if (pGElement instanceof PGLine) {
            return new TextLine(pGElement, this);
        }
        if (pGElement instanceof PGLocus) {
            return new TextElement(pGElement, this);
        }
        if (pGElement instanceof PGText) {
            return new TextElement(pGElement, (ViewPort)this, null);
        }
        if (pGElement instanceof PGConic) {
            return new TextConic(pGElement, this);
        }
        if (pGElement instanceof PGPolygon) {
            return new TextPolygon(pGElement, this);
        }
        if (pGElement instanceof PGAngle) {
            return new TextAngle(pGElement, this);
        }
        if (pGElement instanceof PGDistance) {
            return new TextDistance(pGElement, this);
        }
        if (pGElement instanceof PGArea) {
            return new TextElement(pGElement, (ViewPort)this, null);
        }
        if (pGElement instanceof PGSegment) {
            return new TextLine(pGElement, this);
        }
        return null;
    }

    public final void toVec(int n, int n2, Vec vec) {
    }

    public final void toVec(Point point, Vec vec) {
    }

    public final boolean toPoint(Vec vec, Point point) {
        return false;
    }

    public final boolean toPoint(Vec vec, DoublePoint doublePoint) {
        return false;
    }

    public final void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.width > 0 && this.height > 0) {
            this.updateBounds();
        }
    }

    public final void updateBounds() {
        this.elements.forceRecalc();
        this.repaint();
    }

    public final void setKernel(Cindy cindy) {
        this.kernel = cindy;
        if (this.myListener != null) {
            this.removeMouseListener(this.myListener);
            this.removeMouseMotionListener(this.myListener);
        }
        this.myListener = new TextPortListener(cindy);
        this.addMouseListener(this.myListener);
        this.addMouseMotionListener(this.myListener);
        this.pointCT = cindy.f18.pointCT;
        this.lineCT = cindy.f18.lineCT;
        this.polyCT = cindy.f18.polyCT;
        this.lociCT = cindy.f18.lociCT;
        cindy.f16.addObserver(this);
    }

    public final void reset() {
        super.reset();
        this.repaint();
    }

    public final void paintScrollbar(Graphics graphics) {
        double d;
        graphics.setColor(this.pointCT.highlight.level[3]);
        graphics.fillRect(this.width - 10, this.head, 10, this.height - this.head - 1);
        this.all = this.kernel.f15.pgelements.size() * (textViewD + textViewA + 3);
        this.show = this.height - this.head - 1;
        this.top = this.head - this.yoff;
        this.bot = this.top + this.show;
        double d2 = (double)this.top / (double)this.all;
        double d3 = (double)this.bot / (double)this.all;
        this.slifact = d = (double)this.show / (double)this.all;
        this.slitop = Math.max(this.head, this.head + (int)((double)this.show * d2));
        this.slibot = Math.min(this.height, this.head + (int)((double)this.show * d3));
        int n = this.slibot - this.slitop;
        graphics.setColor(this.pointCT.highlight.level[9]);
        graphics.fillRect(this.width - 10, this.slitop, 10, n);
        graphics.setColor(this.pointCT.black.level[3]);
        graphics.drawRect(this.width - 10, this.head, 10, this.height - this.head - 1);
        graphics.drawRect(this.width - 9, this.slitop, 8, n);
    }

    public final void paintAfterMesh(Graphics graphics) {
        graphics.setColor(this.lineCT.black.full);
        Color color = this.pointCT.black.full;
        Color color2 = this.pointCT.background.full;
        int n = -10;
        int n2 = 5;
        graphics.setColor(color2);
        graphics.fillRect(0, 0, this.width, this.head);
        graphics.fillRect(1 + this.posLabel + this.xoff, n + this.head - textViewA, this.bLabel - 1, textViewD + textViewA);
        graphics.setColor(color);
        graphics.drawString(Intl.getMessage("TextPortLabel"), n2 + this.posLabel + this.xoff, n + this.head);
        graphics.setColor(color2);
        graphics.fillRect(1 + this.posAlg + this.xoff, n + this.head - textViewA, this.bAlg - 1, textViewD + textViewA);
        graphics.setColor(color);
        graphics.drawString(Intl.getMessage("TextPortAlgorithm"), n2 + this.posAlg, n + this.head);
        graphics.setColor(color2);
        graphics.fillRect(1 + this.posCoord + this.xoff, n + this.head - textViewA, this.bCoord - 1, textViewD + textViewA);
        graphics.setColor(color);
        graphics.drawString(Intl.getMessage("TextPortCoord"), n2 + this.posCoord, n + this.head);
        graphics.setColor(this.lineCT.black.level[3]);
        graphics.drawLine(0, this.head - 2, this.width, this.head - 2);
        graphics.drawLine(0, this.head, this.width, this.head);
        graphics.drawLine(this.posLabel, 0, this.posLabel, this.height);
        graphics.drawLine(this.posAlg, 0, this.posAlg, this.height);
        graphics.drawLine(this.posCoord, 0, this.posCoord, this.height);
        this.paintScrollbar(graphics);
    }

    public final void setPortFont(Graphics graphics) {
        graphics.setFont(textViewFont);
    }

    public final void paint(Graphics graphics) {
        this.posLabel = this.bStart;
        this.posAlg = this.posLabel + this.bLabel;
        this.posCoord = this.posAlg + this.bAlg;
        int cfr_ignored_0 = this.posCoord + this.bCoord;
        super.paint(graphics);
    }

    public final void toTop() {
        this.all = this.kernel.f15.pgelements.size() * (textViewD + textViewA + 3);
        int n = this.height - 4 - this.all;
        this.yoff = n > this.head ? this.head : n;
    }

    public final void toBot() {
        this.yoff = this.head;
    }

    public final void addTmpPGElement(PGElement pGElement) {
        super.addTmpPGElement(pGElement);
        this.toTop();
    }

    public final void addPGElement(PGElement pGElement) {
        super.addPGElement(pGElement);
        this.toTop();
    }
}

