/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.controls.MixColor;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGFlat;
import de.cinderella.ports.TextElement;
import de.cinderella.ports.ViewPort;
import java.awt.Graphics;

public class TextPoint
extends TextElement {
    public int size;
    public int px;
    public int py;

    public TextPoint(PGElement pGElement, ViewPort viewPort) {
        this.idea = pGElement;
        this.myPort = viewPort;
        this.recalc();
    }

    public final void recalc() {
        super.recalc();
        PGFlat pGFlat = (PGFlat)this.idea;
        this.size = pGFlat.f9.point_thickness;
        this.size = this.size > 5 ? 5 : this.size;
        this.px = this.x - this.size;
        this.py = this.y - this.size - TextElement.textViewA / 2;
        this.size *= 2;
    }

    public final void draw(Graphics graphics) {
        super.draw(graphics);
        int n = this.idea.f9.visibility;
        if (n == 0) {
            n = 1;
        }
        MixColor mixColor = this.myPort.pointCT.table[this.idea.f9.color];
        graphics.setColor(this.idea.isMovable() ? mixColor.level[n] : mixColor.darker[n]);
        graphics.fillOval(this.px + this.xoff, this.py + this.yoff, this.size, this.size);
        graphics.setColor(this.myPort.pointCT.black.level[n]);
        graphics.drawOval(this.px + this.xoff, this.py + this.yoff, this.size, this.size);
    }
}

