/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.controls.MixColor;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.ports.TextElement;
import de.cinderella.ports.ViewPort;
import java.awt.Graphics;

public class TextConic
extends TextElement {
    public int sx;
    public int sy;
    public int w;
    public int h;

    public TextConic(PGElement pGElement, ViewPort viewPort) {
        this.idea = pGElement;
        this.myPort = viewPort;
        this.recalc();
    }

    public final void recalc() {
        super.recalc();
        PGConic pGConic = (PGConic)this.idea;
        if (pGConic.isCircle || pGConic.isHCircle || pGConic.isECircle) {
            this.sx = this.x - 6;
            this.sy = this.y - TextElement.textViewA / 2 - 6;
            this.w = 12;
            this.h = 12;
            return;
        }
        this.sx = this.x - 7;
        this.sy = this.y - TextElement.textViewA / 2 - 5;
        this.w = 14;
        this.h = 10;
    }

    public final void draw(Graphics graphics) {
        super.draw(graphics);
        int n = this.idea.f9.visibility;
        if (n == 0) {
            n = 1;
        }
        MixColor mixColor = this.myPort.lineCT.table[this.idea.f9.color];
        graphics.setColor(mixColor.level[n]);
        graphics.drawOval(this.sx + this.xoff, this.sy + this.yoff, this.w, this.h);
        int n2 = this.idea.f9.line_thickness;
        if (n2 == 2) {
            graphics.drawOval(this.sx - 1 + this.xoff, this.sy - 1 + this.yoff, this.w + 2, this.h + 2);
            graphics.fillOval(this.sx - 1 + this.xoff, this.sy - 1 + this.yoff, this.w + 2, this.h + 2);
            graphics.setColor(this.myPort.lineCT.background.full);
            graphics.drawOval(this.sx + 1 + this.xoff, this.sy + 1 + this.yoff, this.w - 2, this.h - 2);
            graphics.fillOval(this.sx + 1 + this.xoff, this.sy + 1 + this.yoff, this.w - 2, this.h - 2);
        }
        if (n2 == 3) {
            graphics.drawOval(this.sx - 2 + this.xoff, this.sy - 2 + this.yoff, this.w + 4, this.h + 4);
            graphics.fillOval(this.sx - 2 + this.xoff, this.sy - 2 + this.yoff, this.w + 4, this.h + 4);
            graphics.setColor(this.myPort.lineCT.background.full);
            graphics.drawOval(this.sx + 2 + this.xoff, this.sy + 2 + this.yoff, this.w - 4, this.h - 4);
            graphics.fillOval(this.sx + 2 + this.xoff, this.sy + 2 + this.yoff, this.w - 4, this.h - 4);
        }
    }
}

