/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.controls.ObservableInt;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Matrix3D;
import de.cinderella.math.Vec;
import de.cinderella.ports.Appearance;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Observable;

public final class SphericalPort
extends ViewPort
implements ComponentListener {
    public Matrix3D f269 = new Matrix3D();
    public Point f40 = new Point();
    public int f270;
    public double f271 = 1.0;
    public double f272 = 1.0;
    public ObservableInt f273 = new ObservableInt("scaleSphere", 500);
    public Vec f48 = new Vec();
    public Vec f274 = new Vec();

    public SphericalPort() {
        this.f273.addObserver(this);
        this.pref = new Dimension(400, 400);
    }

    public final ViewPortElement fittingPGElement(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            if (this.polar) {
                return new c113(pGElement, this);
            }
            return new c111(pGElement, this);
        }
        if (pGElement instanceof PGLine) {
            if (this.polar) {
                return new c111(pGElement, this);
            }
            return new c113(pGElement, this);
        }
        if (pGElement instanceof PGSegment) {
            if (this.polar) {
                return new c111(pGElement, this);
            }
            return new c113(pGElement, this);
        }
        if (pGElement instanceof PGConic) {
            return new c112(pGElement, this);
        }
        if (pGElement instanceof PGLocus) {
            return new c110(pGElement, this);
        }
        if (pGElement instanceof PGPolygon) {
            if (this.polar) {
                return null;
            }
            return new c108(pGElement, this);
        }
        return null;
    }

    public final void toVec(Point point, Vec vec) {
        this.toVec(point.x, point.y, vec);
    }

    public final void toVec(int n, int n2, Vec vec) {
        double d;
        double d2;
        double d3 = 1.0 - (d2 = (double)(n - this.f40.x) / (double)this.f270) * d2 - (d = (double)(n2 - this.f40.y) / (double)this.f270) * d;
        this.f48.assign(d2, d, d3 > 0.0 ? Math.sqrt(d3) : 0.0);
        this.f269.transform(this.f48, vec);
        vec.xr *= this.f271;
        vec.yr *= this.f271;
        vec.xi *= this.f271;
        vec.yi *= this.f271;
    }

    public final boolean toPoint(Vec vec, Point point) {
        this.f274.assign(vec);
        this.f274.xr *= this.f272;
        this.f274.yr *= this.f272;
        this.f274.xi *= this.f272;
        this.f274.yi *= this.f272;
        this.f274.normalizeAbs();
        this.f269.inversetfm(this.f274, this.f48);
        point.move((int)(this.f48.xr * (double)this.f270 + (double)this.f40.x), (int)(this.f48.yr * (double)this.f270 + (double)this.f40.y));
        return true;
    }

    public final boolean toPoint(Vec vec, DoublePoint doublePoint) {
        this.f274.assign(vec);
        this.f274.xr *= this.f272;
        this.f274.yr *= this.f272;
        this.f274.xi *= this.f272;
        this.f274.yi *= this.f272;
        this.f274.normalizeAbs();
        this.f269.inversetfm(this.f274, this.f48);
        doublePoint.x = this.f48.xr * (double)this.f270 + (double)this.f40.x;
        doublePoint.y = this.f48.yr * (double)this.f270 + (double)this.f40.y;
        return true;
    }

    public final boolean m76(Vec vec, Point point) {
        this.f274.assign(vec);
        this.f274.xr *= this.f272;
        this.f274.yr *= this.f272;
        this.f274.xi *= this.f272;
        this.f274.yi *= this.f272;
        this.f274.normalizeAbs();
        this.f269.inversetfm(this.f274, this.f48);
        point.move((int)(this.f48.xr * (double)this.f270 + (double)this.f40.x), (int)(this.f48.yr * (double)this.f270 + (double)this.f40.y));
        return this.f48.zr > 0.0;
    }

    public final void m77(Vec vec, int n, DoublePoint doublePoint) {
        this.f274.assign(vec);
        this.f274.xr *= this.f272;
        this.f274.yr *= this.f272;
        this.f274.xi *= this.f272;
        this.f274.yi *= this.f272;
        this.f274.normalizeAbs();
        this.f269.inversetfm(this.f274, this.f48);
        if (this.f48.zr < 0.0) {
            this.f48.mul(-1.0);
        }
        doublePoint.move((double)n * this.f48.xr * (double)this.f270 + (double)this.f40.x, (double)n * this.f48.yr * (double)this.f270 + (double)this.f40.y);
    }

    public final void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.width > 0 && this.height > 0) {
            this.f270 = this.width < this.height ? (int)((double)(this.width / 2) - (double)this.width * 0.07) : (int)((double)(this.height / 2) - (double)this.height * 0.07);
            this.f40.x = this.width / 2;
            this.f40.y = this.height / 2;
            this.elements.resize(this.width, this.height);
            this.elements.forceRecalc();
        }
    }

    public final void paint(Graphics graphics) {
        if (this.oG == null) {
            this.oG = graphics;
            this.oG.setFont(Appearance.textfont);
        }
        this.elements.recalc();
        this.elements.recalcTmp();
        this.oG.setColor(Color.gray);
        this.oG.fillRect(0, 0, this.width, this.height);
        this.oG.setColor(this.pointCT.background.full);
        this.oG.fillOval(this.f40.x - this.f270, this.f40.y - this.f270, 2 * this.f270, 2 * this.f270);
        switch (this.kernel.f32) {
            case 2: {
                this.elements.draftBack(this.oG);
                break;
            }
            case 1: {
                this.elements.draftBack(this.oG);
                break;
            }
            case 0: {
                this.elements.drawBack(this.oG);
            }
        }
        this.oG.setColor(Color.blue);
        this.oG.drawOval(this.f40.x - this.f270, this.f40.y - this.f270, 2 * this.f270, 2 * this.f270);
        switch (this.kernel.f32) {
            case 2: {
                this.elements.draft(this.oG);
                break;
            }
            case 1: {
                this.elements.draft(this.oG);
                break;
            }
            case 0: {
                this.elements.draw(this.oG);
            }
        }
        this.elements.drawLabel(this.oG);
        if (this.oI != null) {
            graphics.drawImage(this.oI, 0, 0, this);
            return;
        }
        this.oG = null;
    }

    public final void update(Observable observable, Object object) {
        double d = (double)((ObservableInt)observable).value / 100.0 - 5.0;
        this.f271 = Math.exp(d);
        this.f272 = 1.0 / this.f271;
        super.forceRecalc();
        this.repaint();
    }

    public final void initFromHTML(Applet applet) {
        super.initFromHTML(applet);
        try {
            this.f271 = new Double(applet.getParameter("scal"));
            this.f272 = new Double(applet.getParameter("scalinv"));
        }
        catch (Exception exception) {
            System.err.println("Error in HTML: check scal and scalinv");
        }
        this.f269 = new Matrix3D();
        try {
            this.f269.xx = new Double(applet.getParameter("mapxx"));
            this.f269.xy = new Double(applet.getParameter("mapxy"));
            this.f269.xz = new Double(applet.getParameter("mapxz"));
            this.f269.yx = new Double(applet.getParameter("mapyx"));
            this.f269.yy = new Double(applet.getParameter("mapyy"));
            this.f269.yz = new Double(applet.getParameter("mapyz"));
            this.f269.zx = new Double(applet.getParameter("mapzx"));
            this.f269.zy = new Double(applet.getParameter("mapzy"));
            this.f269.zz = new Double(applet.getParameter("mapzz"));
            this.f269.ixx = new Double(applet.getParameter("mapixx"));
            this.f269.ixy = new Double(applet.getParameter("mapixy"));
            this.f269.ixz = new Double(applet.getParameter("mapixz"));
            this.f269.iyx = new Double(applet.getParameter("mapiyx"));
            this.f269.iyy = new Double(applet.getParameter("mapiyy"));
            this.f269.iyz = new Double(applet.getParameter("mapiyz"));
            this.f269.izx = new Double(applet.getParameter("mapizx"));
            this.f269.izy = new Double(applet.getParameter("mapizy"));
            this.f269.izz = new Double(applet.getParameter("mapizz"));
        }
        catch (Exception exception) {
            System.err.println("Error in HTML: check map");
        }
        this.componentResized(null);
    }

    public final void softReset() {
        super.softReset();
        this.f271 = 1.0;
        this.f272 = 1.0;
        this.f269 = new Matrix3D();
        this.componentResized(null);
    }
}

