/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.animations;

import de.cinderella.Cindy;
import de.cinderella.algorithms.Movable;
import de.cinderella.controls.ObservableInt;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGFlat;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.Program;
import de.cinderella.math.Vec;
import de.cinderella.ports.EuclideanPort;
import de.cinderella.ports.SphericalPort;
import de.cinderella.ports.ViewPort;

public class Animation
extends Thread {
    public Cindy kernel;
    public Program program;
    public double pi = Math.PI;
    public long startTime;
    public boolean active = false;
    public int type;
    public PGFlat mover;
    public PGFlat tracer;
    public PGConic roadC;
    public PGFlat road;
    public Vec oldpos;
    public Vec orth;
    public Vec mid;
    public Vec nextPoint;
    public double rad;
    public double ax;
    public double ay;
    public double az;
    public double bx;
    public double by;
    public double bz;
    public ObservableInt speed;
    public int dir;
    public double w;
    public double s;
    public double c;
    public Movable alg;
    public ViewPort port;
    public boolean started;
    public boolean flipping;

    public final void run() {
        this.startAnimation();
        while (true) {
            this.actionPerformed();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                this.actionPerformed();
                return;
            }
        }
    }

    public final void startAnimation() {
        if (!this.active) {
            this.initAnimation();
            this.active = true;
        }
        this.startTime = System.currentTimeMillis();
        this.started = true;
        this.flipping = true;
    }

    public final void actionPerformed() {
        long l = System.currentTimeMillis();
        this.step(l - this.startTime);
        this.startTime = l;
    }

    public final void step(long l) {
        double d = 1.7453292519943296E-4 * (double)this.speed.value;
        this.s = Math.sin(this.w);
        this.c = Math.cos(this.w);
        this.nextPoint.assign(this.s * this.ax + this.c * this.bx + this.mid.xr, this.s * this.ay + this.c * this.by + this.mid.yr, this.s * this.az + this.c * this.bz + this.mid.zr);
        this.alg.initMove(this.mover, this.nextPoint);
        this.kernel.f15.recalc(this.alg);
        if (this.flipping && (this.tracer == null && !this.kernel.f15.real || this.tracer != null && !this.tracer.f1)) {
            this.dir *= -1;
            if (this.started) {
                this.flipping = false;
            }
        } else {
            this.kernel.f17.redraw();
        }
        this.started = false;
        this.w += d * (double)this.dir;
    }

    public final void initAnimation() {
        if (!this.program.locusRecursion) {
            if (this.type == 1) {
                this.mid.assign(this.road.f115).normalizeMax().normalizeAbs();
                this.oldpos.assign(this.mover.f115).normalizeMax().normalizeAbs();
                if (this.port == null || this.port instanceof SphericalPort) {
                    this.orth.cross(this.mid, this.oldpos);
                }
                if (this.port instanceof EuclideanPort) {
                    this.orth.cross(Vec.e3, this.road.f115).normalizeAbs();
                    this.orth.div(((EuclideanPort)this.port).f39 / 10.0);
                }
                this.ax = this.orth.xr;
                this.ay = this.orth.yr;
                this.az = this.orth.zr;
                this.bx = this.oldpos.xr;
                this.by = this.oldpos.yr;
                this.bz = this.oldpos.zr;
                this.w = 0.0;
                this.mid.assign(0.0, 0.0, 0.0);
            }
            if (this.type == 2) {
                this.oldpos.cross(this.mover.f115, Vec.e3).normalizeAbs();
                this.orth.assign(-this.oldpos.yr, this.oldpos.xr, 0.0);
                this.ax = this.orth.xr;
                this.ay = this.orth.yr;
                this.az = this.orth.zr;
                this.bx = this.oldpos.xr;
                this.by = this.oldpos.yr;
                this.bz = this.oldpos.zr;
                this.w = 0.0;
                this.mid.assign(0.0, 0.0, 0.0);
            }
            if (this.type == 0) {
                this.mid.center(this.roadC.ccoord).normalizeZ();
                this.oldpos.assign(this.mover.f115).normalizeZ();
                this.ax = this.rad = Math.sqrt((this.mid.xr - this.oldpos.xr) * (this.mid.xr - this.oldpos.xr) + (this.mid.yr - this.oldpos.yr) * (this.mid.yr - this.oldpos.yr));
                this.ay = 0.0;
                this.az = 0.0;
                this.bx = 0.0;
                this.by = this.rad;
                this.bz = 0.0;
                this.w = this.pi + Math.atan2(this.mid.xr - this.oldpos.xr, this.mid.yr - this.oldpos.yr);
            }
            this.dir = 1;
            this.kernel.f15.register.store(5);
            this.kernel.f15.register.copy(0, 6);
            this.program.locusRecursion = true;
        }
    }

    public final void setParameters(PGElement pGElement, PGElement pGElement2, PGElement pGElement3, int n) {
        this.mover = (PGFlat)pGElement;
        if (pGElement2 instanceof PGConic) {
            this.roadC = (PGConic)pGElement2;
            this.type = 0;
        } else {
            this.road = (PGFlat)pGElement2;
            this.type = pGElement instanceof PGPoint ? 1 : 2;
        }
        this.tracer = (PGFlat)pGElement3;
        this.alg = (Movable)((Object)this.mover.f8);
        this.speed.setValue(n);
    }

    public Animation() {
        PGElement[] cfr_ignored_0 = new PGElement[0];
        this.oldpos = new Vec();
        this.orth = new Vec();
        new Vec();
        this.mid = new Vec();
        this.nextPoint = new Vec();
        this.speed = new ObservableInt("AnimSpeed", 500);
        this.dir = 1;
        this.started = false;
        this.flipping = false;
    }
}

