/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.algorithms.Algorithm;
import de.cinderella.geometry.PGElement;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import de.cinderella.ports.ViewPortElementVector;
import java.awt.Graphics;

public final class ViewPortElements {
    public int depth;
    public ViewPortElementVector[] plane;
    public ViewPortElementVector[] temp;
    public ViewPort mVP;

    public ViewPortElements() {
    }

    public ViewPortElements(ViewPort viewPort) {
        this.mVP = viewPort;
        this.depth = 4;
        this.plane = new ViewPortElementVector[this.depth];
        this.temp = new ViewPortElementVector[this.depth];
        int n = 0;
        while (n < this.depth) {
            this.plane[n] = new ViewPortElementVector(this.mVP);
            this.temp[n] = new ViewPortElementVector(2, this.mVP);
            ++n;
        }
    }

    public final void recalc() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].recalc();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.depth) {
            this.temp[n2].recalc();
            ++n2;
        }
    }

    public final void recalcPS() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].recalcPS();
            ++n;
        }
    }

    public final void forceRecalc() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].forceRecalc();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.depth) {
            this.temp[n2].forceRecalc();
            ++n2;
        }
    }

    public final void resize(int n, int n2) {
        int n3 = 0;
        while (n3 < this.depth) {
            this.plane[n3].resize(n, n2);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.depth) {
            this.temp[n4].resize(n, n2);
            ++n4;
        }
    }

    public final void recalcTmp() {
        int n = 0;
        while (n < this.depth) {
            this.temp[n].recalc();
            ++n;
        }
    }

    public final void add(ViewPortElement viewPortElement) {
        viewPortElement.create();
        this.plane[viewPortElement.plane()].add(viewPortElement);
    }

    public final void addTmp(ViewPortElement viewPortElement) {
        viewPortElement.createTmp();
        this.temp[viewPortElement.plane()].add(viewPortElement);
    }

    public final void delete(PGElement pGElement) {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].delete(pGElement);
            ++n;
        }
    }

    public final void clear() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].clear();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.depth) {
            this.temp[n2].clearTmp();
            ++n2;
        }
    }

    public final void clearTmp() {
        int n = 0;
        while (n < this.depth) {
            this.temp[n].clearTmp();
            ++n;
        }
    }

    public final void printPS() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].printPS();
            this.temp[n].printPS();
            ++n;
        }
    }

    public final void printLabelPS() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].printLabelPS();
            this.temp[n].printLabelPS();
            ++n;
        }
    }

    public final void printBackPS() {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].printBackPS();
            this.temp[n].printBackPS();
            ++n;
        }
    }

    public final void drawLabel(Graphics graphics) {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].drawLabel(graphics);
            this.temp[n].drawLabel(graphics);
            ++n;
        }
    }

    public final void draw(Graphics graphics) {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].draw(graphics);
            this.temp[n].draw(graphics);
            ++n;
        }
    }

    public final void drawBack(Graphics graphics) {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].drawBack(graphics);
            this.temp[n].drawBack(graphics);
            ++n;
        }
    }

    public final void draft(Graphics graphics) {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].draft(graphics);
            this.temp[n].draft(graphics);
            ++n;
        }
    }

    public final void draftBack(Graphics graphics) {
        int n = 0;
        while (n < this.depth) {
            this.plane[n].draftBack(graphics);
            this.temp[n].draftBack(graphics);
            ++n;
        }
    }

    public final ViewPortElement findLabel(int n, int n2) {
        ViewPortElement viewPortElement = null;
        int n3 = this.depth - 1;
        while (n3 >= 0 && (viewPortElement = this.plane[n3].findLabel(n, n2)) == null) {
            --n3;
        }
        return viewPortElement;
    }

    public final PGElement findMovable(int n, int n2) {
        PGElement pGElement = null;
        int n3 = this.depth - 1;
        while (n3 >= 0 && (pGElement = this.plane[n3].findMovable(n, n2)) == null) {
            --n3;
        }
        return pGElement;
    }

    public final PGElement findDockable(int n, int n2, PGElement pGElement) {
        PGElement pGElement2 = null;
        int n3 = this.depth - 1;
        while (n3 >= 0 && (pGElement2 = this.plane[n3].findDockable(n, n2, pGElement)) == null) {
            --n3;
        }
        return pGElement2;
    }

    public final Algorithm getAlgorithmAtPoint(Class clazz, int n, int n2) {
        Algorithm algorithm = null;
        int n3 = this.depth - 1;
        while (n3 >= 0 && (algorithm = this.plane[n3].getAlgorithmAtPoint(clazz, n, n2)) == null) {
            --n3;
        }
        return algorithm;
    }

    public final PGElement getElementAtPoint(Class clazz, int n, int n2) {
        PGElement pGElement = null;
        int n3 = this.depth - 1;
        while (n3 >= 0 && (pGElement = this.plane[n3].getElementAtPoint(clazz, n, n2)) == null) {
            --n3;
        }
        return pGElement;
    }
}

