/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.algorithms.Algorithm;
import de.cinderella.algorithms.FreePoint;
import de.cinderella.algorithms.IntersectionCircleCircle;
import de.cinderella.algorithms.IntersectionConicConic;
import de.cinderella.algorithms.IntersectionConicLine;
import de.cinderella.algorithms.Locus;
import de.cinderella.algorithms.Meet;
import de.cinderella.algorithms.Movable;
import de.cinderella.algorithms.OtherIntersectionCC;
import de.cinderella.algorithms.OtherIntersectionCL;
import de.cinderella.algorithms.PointOnCircle;
import de.cinderella.algorithms.PointOnLine;
import de.cinderella.geometry.Geometry;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.geometry.PGText;
import de.cinderella.math.Mat;
import de.cinderella.math.Vec;
import de.cinderella.ports.ViewPort;
import java.util.Vector;

public final class Hotlist {
    public Vector points = new Vector(3);
    public Vector lines = new Vector(3);
    public Vector conics = new Vector(3);
    public Vector texts = new Vector(3);
    public Vector loci = new Vector(3);
    public Vector polygons = new Vector(3);
    public Vector segments = new Vector(3);
    public Vector rest = new Vector(3);
    public Vec v = new Vec();
    public Vec p1 = new Vec();
    public Vec p2 = new Vec();
    public Vec p3 = new Vec();
    public Vec p4 = new Vec();
    public Vec nearest = new Vec();
    public int x;
    public int y;
    public Cindy kernel;

    private Hotlist() {
        new Mat();
        new Mat();
    }

    public Hotlist(Cindy cindy) {
        new Mat();
        new Mat();
        this.kernel = cindy;
    }

    public final void update(ViewPort viewPort, int n, int n2) {
        this.x = n;
        this.y = n2;
        viewPort.toVec(n, n2, this.v);
        this.clear();
        int n3 = viewPort.elements.depth - 1;
        while (n3 >= 0 && !viewPort.elements.plane[n3].addHot(this)) {
            --n3;
        }
    }

    public final void updateAll(ViewPort viewPort, int n, int n2) {
        this.x = n;
        this.y = n2;
        viewPort.toVec(n, n2, this.v);
        this.clear();
        int n3 = viewPort.elements.depth - 1;
        while (n3 >= 0 && !viewPort.elements.plane[n3].addHotAll(this)) {
            --n3;
        }
    }

    public final Vec getPosition() {
        if (this.points.size() == 1) {
            return ((PGPoint)this.points.elementAt((int)0)).f127;
        }
        if (this.lines.size() == 2 && this.conics.size() == 0) {
            this.v.cross(((PGLine)this.lines.elementAt((int)0)).f127, ((PGLine)this.lines.elementAt((int)1)).f127);
        } else if (this.lines.size() == 1 && this.conics.size() == 1) {
            ((PGConic)this.conics.elementAt((int)0)).f125.intersectConicWithLine(((PGLine)this.lines.elementAt((int)0)).f127, this.p1, this.p2);
            this.v.assign(this.v.getNearest(this.p1, this.p2, 1.0));
        } else if (this.lines.size() == 0 && this.conics.size() == 2) {
            if (((PGConic)this.conics.elementAt((int)0)).f122 && ((PGConic)this.conics.elementAt((int)1)).f122) {
                ((PGConic)this.conics.elementAt((int)0)).f125.intersectCircleWithCircle(((PGConic)this.conics.elementAt((int)1)).f125, this.p1, this.p2);
                this.v.assign(this.v.getNearest(this.p1, this.p2, 1.0));
            } else {
                ((PGConic)this.conics.elementAt((int)0)).f125.intersectConicWithConic(((PGConic)this.conics.elementAt((int)1)).f125, this.p1, this.p2, this.p3, this.p4);
                this.v.assign(this.v.getNearest(this.p1, this.p2, this.p3, this.p4, 1.0));
            }
        } else if (this.lines.size() == 1) {
            Geometry.euclidean.perp(((PGLine)this.lines.elementAt((int)0)).f127, this.v, this.p1);
            this.v.cross(this.p1, ((PGLine)this.lines.elementAt((int)0)).f127);
        } else if (this.conics.size() == 1 && ((PGConic)this.conics.elementAt((int)0)).f122) {
            this.v.project(((PGConic)this.conics.elementAt((int)0)).f125, this.p1, this.p2);
            this.v.assign(this.v.getNearest(this.p1, this.p2, 1.0));
        }
        return this.v;
    }

    public final boolean isMovable() {
        return this.points.size() > 1 || this.points.size() == 0 && this.lines.size() + this.conics.size() != 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final PGElement installTrueAlgorithm() {
        Algorithm algorithm = null;
        switch (this.lines.size()) {
            case 2: {
                if (this.conics.size() == 0) {
                    algorithm = new Meet();
                    algorithm.setInput(new PGElement[]{(PGLine)this.lines.elementAt(0), (PGLine)this.lines.elementAt(1)});
                    algorithm.createOutput();
                    algorithm.recalc();
                    algorithm.store();
                    algorithm.trace();
                    return algorithm.output[0];
                }
            }
            case 1: {
                switch (this.conics.size()) {
                    case 0: {
                        algorithm = new PointOnLine();
                        algorithm.setInput(new PGElement[]{(PGLine)this.lines.elementAt(0)});
                        algorithm.createOutput();
                        ((Movable)((Object)algorithm)).initMove(algorithm.output[0], this.v);
                        ((Movable)((Object)algorithm)).initMove2();
                        ((Movable)((Object)algorithm)).goEnd();
                        algorithm.recalc();
                        algorithm.store();
                        algorithm.trace();
                        return algorithm.output[0];
                    }
                    case 1: {
                        int n;
                        algorithm = new IntersectionConicLine();
                        algorithm.setInput(new PGElement[]{(PGConic)this.conics.elementAt(0), (PGLine)this.lines.elementAt(0)});
                        algorithm.createOutput();
                        algorithm.recalc();
                        algorithm.store();
                        algorithm.trace();
                        this.nearest = this.v.getNearest(((PGPoint)algorithm.output[0]).f127, ((PGPoint)algorithm.output[1]).f127, 1.0);
                        this.kernel.f15.verbose = false;
                        PGElement pGElement = this.kernel.f15.addElement(algorithm.output[this.nearest == ((PGPoint)algorithm.output[0]).f127 ? 1 : 0]);
                        this.kernel.f15.verbose = true;
                        if (pGElement != algorithm.output[this.nearest == ((PGPoint)algorithm.output[0]).f127 ? 1 : 0]) {
                            algorithm = new OtherIntersectionCL();
                            algorithm.setInput(new PGElement[]{(PGConic)this.conics.elementAt(0), (PGLine)this.lines.elementAt(0), pGElement});
                            algorithm.createOutput();
                            algorithm.recalc();
                            algorithm.store();
                            algorithm.trace();
                            return algorithm.output[0];
                        }
                        this.kernel.f15.deleteElement(pGElement);
                        PGElement[] pGElementArray = algorithm.output;
                        if (this.nearest == ((PGPoint)algorithm.output[0]).f127) {
                            n = 0;
                            return pGElementArray[n];
                        }
                        n = 1;
                        return pGElementArray[n];
                    }
                }
            }
            case 0: {
                switch (this.conics.size()) {
                    case 2: {
                        int n;
                        if (((PGConic)this.conics.elementAt((int)0)).f122 && ((PGConic)this.conics.elementAt((int)1)).f122) {
                            int n2;
                            algorithm = new IntersectionCircleCircle();
                            algorithm.setInput(new PGElement[]{(PGConic)this.conics.elementAt(0), (PGConic)this.conics.elementAt(1)});
                            algorithm.createOutput();
                            algorithm.recalc();
                            algorithm.store();
                            algorithm.trace();
                            this.nearest = this.v.getNearest(((PGPoint)algorithm.output[0]).f127, ((PGPoint)algorithm.output[1]).f127, 1.0);
                            this.kernel.f15.verbose = false;
                            PGElement pGElement = this.kernel.f15.addElement(algorithm.output[this.nearest == ((PGPoint)algorithm.output[0]).f127 ? 1 : 0]);
                            this.kernel.f15.verbose = true;
                            if (pGElement != algorithm.output[this.nearest == ((PGPoint)algorithm.output[0]).f127 ? 1 : 0]) {
                                algorithm = new OtherIntersectionCC();
                                algorithm.setInput(new PGElement[]{(PGConic)this.conics.elementAt(0), (PGConic)this.conics.elementAt(1), pGElement});
                                algorithm.createOutput();
                                algorithm.recalc();
                                algorithm.store();
                                algorithm.trace();
                                return algorithm.output[0];
                            }
                            this.kernel.f15.deleteElement(pGElement);
                            PGElement[] pGElementArray = algorithm.output;
                            if (this.nearest == ((PGPoint)algorithm.output[0]).f127) {
                                n2 = 0;
                                return pGElementArray[n2];
                            }
                            n2 = 1;
                            return pGElementArray[n2];
                        }
                        algorithm = new IntersectionConicConic();
                        algorithm.setInput(new PGElement[]{(PGConic)this.conics.elementAt(0), (PGConic)this.conics.elementAt(1)});
                        algorithm.createOutput();
                        algorithm.recalc();
                        algorithm.store();
                        algorithm.trace();
                        this.nearest = this.v.getNearest(((PGPoint)algorithm.output[0]).f127, ((PGPoint)algorithm.output[1]).f127, ((PGPoint)algorithm.output[2]).f127, ((PGPoint)algorithm.output[3]).f127, 1.0);
                        PGElement[] pGElementArray = algorithm.output;
                        if (this.nearest == ((PGPoint)algorithm.output[0]).f127) {
                            n = 0;
                            return pGElementArray[n];
                        }
                        if (this.nearest == ((PGPoint)algorithm.output[1]).f127) {
                            n = 1;
                            return pGElementArray[n];
                        }
                        if (this.nearest == ((PGPoint)algorithm.output[2]).f127) {
                            n = 2;
                            return pGElementArray[n];
                        }
                        n = 3;
                        return pGElementArray[n];
                    }
                    case 1: {
                        int n;
                        if (!((PGConic)this.conics.elementAt((int)0)).f122) break;
                        algorithm = new PointOnCircle();
                        algorithm.setInput(new PGElement[]{(PGConic)this.conics.elementAt(0)});
                        algorithm.createOutput();
                        ((Movable)((Object)algorithm)).initMove(algorithm.output[0], this.v);
                        ((Movable)((Object)algorithm)).initMove2();
                        ((Movable)((Object)algorithm)).goEnd();
                        algorithm.recalc();
                        algorithm.store();
                        algorithm.trace();
                        this.nearest = this.v.getNearest(((PGPoint)algorithm.output[0]).f127, ((PGPoint)algorithm.output[1]).f127, 1.0);
                        PGElement[] pGElementArray = algorithm.output;
                        if (this.nearest == ((PGPoint)algorithm.output[0]).f127) {
                            n = 0;
                            return pGElementArray[n];
                        }
                        n = 1;
                        return pGElementArray[n];
                    }
                }
                break;
            }
        }
        algorithm = new FreePoint();
        algorithm.createOutput();
        ((Movable)((Object)algorithm)).initMove(algorithm.output[0], this.v);
        ((Movable)((Object)algorithm)).initMove2();
        ((Movable)((Object)algorithm)).goEnd();
        algorithm.recalc();
        algorithm.store();
        algorithm.trace();
        return algorithm.output[0];
    }

    public final boolean isOldPoint() {
        return this.points.size() == 1;
    }

    public final PGPoint getOldPoint() {
        return (PGPoint)this.points.elementAt(0);
    }

    public final void insert(PGElement pGElement) {
        if (pGElement.f9 instanceof Locus) {
            this.loci.addElement(pGElement);
            return;
        }
        if (pGElement instanceof PGLine) {
            this.lines.addElement(pGElement);
            return;
        }
        if (pGElement instanceof PGPoint) {
            this.points.addElement(pGElement);
            return;
        }
        if (pGElement instanceof PGConic) {
            this.conics.addElement(pGElement);
            return;
        }
        if (pGElement instanceof PGText) {
            this.texts.addElement(pGElement);
            return;
        }
        if (pGElement instanceof PGPolygon) {
            this.polygons.addElement(pGElement);
            return;
        }
        if (pGElement instanceof PGSegment) {
            this.segments.addElement(pGElement);
            return;
        }
        this.rest.addElement(pGElement);
    }

    public final void clear() {
        this.points.removeAllElements();
        this.conics.removeAllElements();
        this.lines.removeAllElements();
        this.segments.removeAllElements();
        this.texts.removeAllElements();
        this.loci.removeAllElements();
        this.polygons.removeAllElements();
        this.rest.removeAllElements();
    }

    public final void setSelect(boolean bl) {
        this.setSelect(this.points, bl);
        this.setSelect(this.conics, bl);
        this.setSelect(this.lines, bl);
        this.setSelect(this.segments, bl);
        this.setSelect(this.texts, bl);
        this.setSelect(this.loci, bl);
        this.setSelect(this.polygons, bl);
        this.setSelect(this.rest, bl);
    }

    public final void setSelect(Vector vector, boolean bl) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((PGElement)vector.elementAt((int)n2)).f2 = bl;
            ++n2;
        }
    }

    public final void toggleSelect(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((PGElement)vector.elementAt(n2)).m4();
            ++n2;
        }
    }

    public final void toggleSelect() {
        this.toggleSelect(this.points);
        this.toggleSelect(this.conics);
        this.toggleSelect(this.lines);
        this.toggleSelect(this.texts);
        this.toggleSelect(this.loci);
        this.toggleSelect(this.polygons);
        this.toggleSelect(this.segments);
        this.toggleSelect(this.rest);
    }
}

