/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.animations.Animation;
import de.cinderella.controls.FileOps;
import de.cinderella.controls.Intl;
import de.cinderella.controls.LWFrame;
import de.cinderella.controls.ResourceImage;
import de.cinderella.controls.StatusLine;
import de.cinderella.controls.Toolbar;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.Program;
import de.cinderella.modes.AnimationMode;
import de.cinderella.ports.Dispatcher$1;
import de.cinderella.ports.TextPort;
import de.cinderella.ports.ViewPort;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Dispatcher {
    public Cindy kernel;
    public Program program;
    public ViewPort[] ports = new ViewPort[20];
    public Hashtable frames = new Hashtable();
    public int nofPorts;

    public final void setCursor(int n, Class clazz) {
        int n2 = 0;
        while (n2 < this.nofPorts) {
            ViewPort viewPort = this.ports[n2];
            if (clazz == null || clazz.isInstance(viewPort)) {
                viewPort.setCursor(Cursor.getPredefinedCursor(n));
            }
            ++n2;
        }
    }

    public final void setCursorWait() {
        int n = 0;
        while (n < this.nofPorts) {
            ViewPort viewPort = this.ports[n];
            Frame frame = (Frame)this.frames.get(viewPort);
            if (frame != null) {
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
                frame.getToolkit().sync();
            }
            ++n;
        }
    }

    public final void setCursorDefault() {
        int n = 0;
        while (n < this.nofPorts) {
            ViewPort viewPort = this.ports[n];
            Frame frame = (Frame)this.frames.get(viewPort);
            if (frame != null) {
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                frame.getToolkit().sync();
            }
            ++n;
        }
    }

    public final void setTitle(String string) {
        int n = 0;
        while (n < this.nofPorts) {
            Component component = this.ports[n];
            while (!(component instanceof Frame) && component != null) {
                component = component.getParent();
            }
            if (component != null) {
                ((Frame)component).setTitle(string);
            }
            ++n;
        }
    }

    public final void addPGElement(PGElement pGElement) {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].addPGElement(pGElement);
            ++n;
        }
        pGElement.f3 = true;
    }

    public final void addTmpPGElement(PGElement pGElement) {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].addTmpPGElement(pGElement);
            ++n;
        }
    }

    public final void clearTmp() {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].elements.clearTmp();
            ++n;
        }
    }

    public final void redraw() {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].repaint();
            ++n;
        }
    }

    public final void forceRecalc() {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].forceRecalc();
            this.ports[n].repaint();
            ++n;
        }
    }

    public final void redrawLater() {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].repaint();
            ++n;
        }
    }

    public final void redrawTmp() {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].repaint();
            ++n;
        }
    }

    public final void reset() {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].reset();
            this.ports[n].repaint();
            ++n;
        }
    }

    public final void delete(PGElement pGElement) {
        int n = 0;
        while (n < this.nofPorts) {
            this.ports[n].elements.delete(pGElement);
            ++n;
        }
        pGElement.f3 = false;
    }

    public final void addPort(ViewPort viewPort, int n) {
        this.ports[n] = viewPort;
        viewPort.setID(1 << n);
    }

    public final void initPort(ViewPort viewPort) {
        viewPort.myProgram = this.program;
        viewPort.setKernel(this.kernel);
    }

    public final void sendProgram() {
        int n = 0;
        while (n < this.nofPorts) {
            this.sendProgram(this.ports[n]);
            this.ports[n].repaint();
            ++n;
        }
    }

    public final void sendProgram(ViewPort viewPort) {
        int n = 0;
        while (n < this.program.pgelements.size()) {
            PGElement pGElement = (PGElement)this.program.pgelements.elementAt(n);
            if (!this.kernel.f26 || pGElement.f3 || this.kernel.f24 != null && this.kernel.f24.m66(pGElement)) {
                viewPort.addPGElement(pGElement);
                pGElement.f3 = true;
            }
            ++n;
        }
        viewPort.componentResized(null);
        if (viewPort instanceof TextPort) {
            ((TextPort)viewPort).m138();
        }
    }

    public final void closePort(ViewPort viewPort) {
        int n = 0;
        while (n < this.nofPorts) {
            if (this.ports[n] == viewPort) {
                this.kernel.f23.removePort(viewPort);
                int n2 = n;
                while (n2 < this.nofPorts - 1) {
                    this.ports[n2] = this.ports[n2 + 1];
                    this.ports[n2].setID(1 << n2);
                    ++n2;
                }
                --this.nofPorts;
            }
            ++n;
        }
    }

    public final void closeFrame(LWFrame lWFrame) {
        if (this.nofPorts == 1) {
            if (FileOps.saveBefore("quit", this.kernel) == 1) {
                this.kernel.m9();
            } else {
                return;
            }
        }
        this.closePort(lWFrame.port);
        ((Component)lWFrame).setVisible(false);
    }

    public final void openFrame(ViewPort viewPort) {
        this.initPort(viewPort);
        LWFrame lWFrame = new LWFrame(viewPort.windowTitle());
        lWFrame.setIconImage(ResourceImage.getImage("icon.16.gif"));
        viewPort.frame = lWFrame;
        Dispatcher$1 dispatcher$1 = new Dispatcher$1(this);
        lWFrame.addWindowListener(dispatcher$1);
        Toolbar toolbar = this.kernel.f21.getDefaultToolBar();
        toolbar.setCollapsed(this.nofPorts != 0);
        lWFrame.addComponent(toolbar);
        lWFrame.addComponent(viewPort);
        Toolbar toolbar2 = this.kernel.f21.getToolBar(viewPort);
        if (toolbar2 != null) {
            lWFrame.addComponent(this.kernel.f21.getToolBar(viewPort));
        }
        lWFrame.addComponent(new StatusLine(this.kernel.f22));
        lWFrame.setMenuBar(this.kernel.f21.getDefaultMenuBar());
        lWFrame.pack();
        this.frames.put(viewPort, lWFrame);
        this.addPort(viewPort, this.nofPorts);
        ++this.nofPorts;
        lWFrame.show();
    }

    public final void toHTML(PrintWriter printWriter) {
        this.kernel.f27 = System.currentTimeMillis();
        int n = 0;
        while (n < this.nofPorts) {
            printWriter.println("<applet code     = \"de.cinderella.CindyApplet\"");
            printWriter.println("        archive = \"cindyrun.jar\"");
            printWriter.println("        width    = " + this.ports[n].width);
            printWriter.println("        height   = " + this.ports[n].height + ">");
            printWriter.println("<param  name=kernelID  value=\"" + this.kernel.f27 + "\">");
            String string = this.ports[n].getClass().getName();
            if (this.kernel.f28) {
                Animation animation = ((AnimationMode)this.kernel.f20.value).f485;
                animation.writeHTML(printWriter);
            }
            if (this.kernel.f26) {
                printWriter.println("<param  name=exercise  value=true>");
            }
            printWriter.println("<param  name=viewport value=\"" + string + "\">");
            printWriter.println("<param  name=filename value=\"" + this.program.filename + "\">");
            printWriter.println("<param  name=polar value= \"" + this.ports[n].polar + "\">");
            printWriter.println("<param  name=width value= \"" + this.ports[n].width + "\">");
            printWriter.println("<param  name=height value=\"" + this.ports[n].height + "\">");
            this.ports[n].writeHTML(printWriter);
            printWriter.println(Intl.getMessage("enableJava"));
            printWriter.println("</applet>");
            ++n;
        }
    }
}

