/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.geometry;

import de.cinderella.Cindy;
import de.cinderella.algorithms.Algorithm;
import de.cinderella.algorithms.Conjecture;
import de.cinderella.algorithms.ConjectureEquals;
import de.cinderella.algorithms.ConjectureIncident;
import de.cinderella.algorithms.Locus;
import de.cinderella.algorithms.Movable;
import de.cinderella.algorithms.Text;
import de.cinderella.geometry.Geometry;
import de.cinderella.geometry.PGAngle;
import de.cinderella.geometry.PGBoolean;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGDistance;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGFlat;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGList;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.geometry.PGText;
import de.cinderella.geometry.PGVector;
import de.cinderella.geometry.ProverEvent;
import de.cinderella.geometry.ProverListener;
import de.cinderella.geometry.Register;
import de.cinderella.geometry.UndoRegister;
import de.cinderella.math.Complex;
import de.cinderella.math.MovableReference;
import de.cinderella.math.Vec;
import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Program {
    public PGList pgelements = new PGList(false);
    public String filename;
    public String directory;
    public String user;
    public static int needed;
    public static Graphics progressGraphics;
    public static int progress;
    public boolean prover = true;
    public boolean verbose = true;
    public boolean hasChanged;
    public PGList tmpPGElements = new PGList(true);
    public Vector texts = new Vector();
    public Vector conjectures = new Vector(10);
    public Vector expected = new Vector(3);
    public Vector interesting = new Vector(3);
    public Vector algs = new Vector();
    public Vector tmpAlgs = new Vector(3);
    public Hashtable programs = new Hashtable();
    public Hashtable tracingprograms = new Hashtable();
    public Hashtable elementhash = new Hashtable();
    public Register register = new Register();
    public UndoRegister undoRegister = new UndoRegister();
    public Cindy kernel;
    public boolean real = true;
    public boolean locusRecursion = false;
    public MovableReference lastMover = new MovableReference();
    public Algorithm tracer;
    public boolean change;
    public Complex lambda = new Complex();
    public boolean needRecall = true;
    public Vector listeners = new Vector();

    public Program() {
        this.clear();
    }

    public final void setKernel(Cindy cindy) {
        this.kernel = cindy;
        this.pgelements.setKernel(cindy);
    }

    public final void clear() {
        System.currentTimeMillis();
        this.hasChanged = false;
        this.filename = null;
        this.directory = null;
        this.hasChanged = false;
        this.real = true;
        this.change = true;
        this.locusRecursion = false;
        this.lastMover.m = null;
        this.register = new Register();
        this.register.register(this.lastMover);
        this.undoRegister = new UndoRegister();
        this.undoRegister.register(this.lastMover);
        this.algs.removeAllElements();
        this.tmpAlgs.removeAllElements();
        this.pgelements.removeAllElements();
        this.tmpPGElements.removeAllElements();
        this.programs.clear();
        this.elementhash.clear();
        this.texts.removeAllElements();
        System.gc();
    }

    public final void recalcTmp() {
        int n = this.tmpAlgs.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)this.tmpAlgs.elementAt(n2);
            algorithm.recalc();
            algorithm.store();
            algorithm.trace();
            algorithm.changed = -1;
            ++n2;
        }
        this.updateReality(this.tmpAlgs);
    }

    public final void recalc(Movable movable) {
        this.hasChanged = true;
        if (this.lastMover.m != movable) {
            if (this.lastMover.m != null) {
                this.setCheckpointsToActual((Vector)this.tracingprograms.get(this.lastMover.m));
            } else {
                this.setCheckpointsToActual(this.algs);
            }
            this.lastMover.m = movable;
            this.register.store(0);
        } else if (this.needRecall) {
            this.register.recall(0);
        }
        movable.initMove2();
        if (this.trace(movable)) {
            this.register.store(0);
            this.needRecall = false;
        } else {
            this.needRecall = true;
        }
        Vector vector = (Vector)this.programs.get(movable);
        this.updateReality(vector);
        this.recalcLoci(vector);
    }

    private final void emergency(double d, Complex complex, Movable movable, Algorithm algorithm, Vector vector, Vector vector2, Vector vector3) {
        System.err.println("=======================");
        System.err.println("I AM LOST!");
        System.err.println("Step too small at " + d);
        System.err.println("Lambda is " + complex);
        System.err.println("Moving " + movable);
        System.err.println("Tracer is " + algorithm);
        algorithm.debug();
        System.err.println("\nTracingprogram:\n" + vector);
        System.err.println("\nProgram:\n" + vector2);
        System.err.println("\nUsing:\n" + vector3);
        int n = vector2.size();
        movable.goEnd();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm2 = (Algorithm)vector2.elementAt(n2);
            algorithm2.recalc();
            algorithm2.store();
            algorithm2.trace();
            ++n2;
        }
    }

    public final void refreshMove(Movable movable) {
        Vector vector = (Vector)this.programs.get(movable);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n2);
            algorithm.recalc();
            algorithm.trace();
            ++n2;
        }
    }

    public final void reportProgress(int n) {
        if (n > 100) {
            progressGraphics.setColor(n % 20 < 10 ? Color.blue : Color.red);
            progressGraphics.fillRect(progress - 4, 0, 6, 6);
        }
    }

    public final boolean trace(Movable movable) {
        Vector vector;
        Vector vector2 = (Vector)this.tracingprograms.get(movable);
        Vector vector3 = vector = (Vector)this.programs.get(movable);
        double d = 0.0;
        double d2 = 1.0;
        double d3 = d;
        double d4 = (d2 - d3) / 2.0;
        this.reset(vector2);
        boolean bl = true;
        int n = 0;
        while (d3 < d2) {
            ++n;
            if (progressGraphics != null) {
                this.reportProgress(n);
            }
            double d5 = d3;
            if ((d3 += d4) >= d2) {
                d3 = d2;
                movable.goEnd();
                vector3 = vector;
            } else {
                this.lambda.assign((1.0 - Math.cos(Math.PI * d3)) / 2.0, Math.sin(Math.PI * d3) / 2.0);
                movable.goTo(this.lambda);
                vector3 = vector2;
            }
            switch (this.trace(vector3)) {
                case 0: {
                    d4 *= 1.25;
                    break;
                }
                case 2: {
                    bl = false;
                    d4 *= 1.25;
                    break;
                }
                case 1: {
                    d3 = d5;
                    d4 /= 2.0;
                    if (!(d3 + d4 <= d3)) break;
                    this.emergency(d3, this.lambda, movable, this.tracer, vector2, vector, vector3);
                    d3 = d2;
                    bl = false;
                    this.lastMover.m = null;
                    break;
                }
            }
        }
        this.storeData(vector3);
        if (n > 100 && progressGraphics != null) {
            this.reportProgress(205);
        }
        needed = n;
        return bl;
    }

    private final boolean storeData(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n2);
            algorithm.storeData();
            ++n2;
        }
        return true;
    }

    private final void reset(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Algorithm)vector.elementAt(n2)).reset();
            ++n2;
        }
    }

    private final int trace(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n3);
            if (!(algorithm instanceof Locus)) {
                algorithm.recalc();
                if (this.change) {
                    algorithm.changed = -1;
                }
                this.tracer = algorithm;
                int n4 = algorithm.trace();
                if ((n4 & 1) != 0) {
                    return 1;
                }
                if ((n4 & 2) != 0) {
                    n2 = 2;
                }
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n5);
            algorithm.store();
            ++n5;
        }
        return n2;
    }

    private final void setCheckpointsToActual(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n2);
            algorithm.storeActual();
            ++n2;
        }
    }

    public final void deleteElement(PGElement pGElement) {
        if (this.pgelements.contains(pGElement)) {
            this.pgelements.removeElement(pGElement);
            int n = 0;
            while (n < this.pgelements.size()) {
                Vector vector = ((PGElement)this.pgelements.elementAt((int)n)).f7;
                vector.removeElement(pGElement);
                ++n;
            }
            this.elementhash.remove(pGElement.f8);
            if (pGElement.f9 instanceof Text) {
                this.texts.removeElement(pGElement.f9);
            }
            pGElement.f8 = null;
            this.checkAlgorithms();
        }
        this.reparseTexts(pGElement);
    }

    public final void checkAlgorithms() {
        Vector vector;
        int n = 0;
        while (n < this.algs.size()) {
            vector = (Vector)this.programs.get(this.algs.elementAt(n));
            if (vector != null) {
                this.checkAlgorithms(vector, false);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.algs.size()) {
            vector = (Vector)this.tracingprograms.get(this.algs.elementAt(n2));
            if (vector != null) {
                this.checkAlgorithms(vector, false);
            }
            ++n2;
        }
        this.checkAlgorithms(this.algs, true);
    }

    public final boolean checkAlgorithms(Vector vector, boolean bl) {
        int n = 0;
        while (n < vector.size()) {
            if (this.checkAlgorithm((Algorithm)vector.elementAt(n), bl)) {
                Algorithm algorithm = (Algorithm)vector.elementAt(n);
                vector.removeElementAt(n);
                if (bl && algorithm instanceof Movable) {
                    if (this.lastMover.m == algorithm) {
                        this.lastMover.m = null;
                    }
                    this.programs.remove(algorithm);
                    this.tracingprograms.remove(algorithm);
                }
                --n;
            }
            ++n;
        }
        return vector.size() == 0;
    }

    public final boolean checkAlgorithm(Algorithm algorithm, boolean bl) {
        int n = 0;
        while (n < algorithm.output.length) {
            if (algorithm.output[n].f8 != null && this.elementhash.get(algorithm.output[n].f8) == algorithm.output[n]) {
                return false;
            }
            ++n;
        }
        if (bl) {
            algorithm.unregister();
        }
        return true;
    }

    public final void createExpectations(PGElement pGElement) {
        this.expected.removeAllElements();
        this.interesting.removeAllElements();
        if (pGElement != null) {
            pGElement.f9.getConjectures(this.expected, pGElement);
        }
    }

    public final PGLocus containedLocus(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (((Conjecture)vector.elementAt((int)n)).locus != null) {
                return ((Conjecture)vector.elementAt((int)n)).locus;
            }
            ++n;
        }
        return null;
    }

    public final boolean checkConjectures(PGElement pGElement) {
        new Vec();
        this.change = false;
        this.kernel.f17.setCursorWait();
        this.register.store(1);
        this.register.copy(0, 2);
        PGLocus pGLocus = this.containedLocus(this.conjectures);
        int n = 0;
        while (n < 3 && this.conjectures.size() != 0) {
            Enumeration enumeration = this.programs.keys();
            while (enumeration.hasMoreElements() && this.conjectures.size() != 0) {
                Algorithm algorithm = (Algorithm)enumeration.nextElement();
                if (!(algorithm instanceof Movable) || pGElement != null && !((Vector)this.programs.get(algorithm)).contains(pGElement.f9)) continue;
                ((Movable)((Object)algorithm)).initRandomMove();
                this.recalc((Movable)((Object)algorithm));
                if (pGLocus != null && enumeration.hasMoreElements()) continue;
                if (pGLocus != null) {
                    pGLocus.m46();
                }
                int n2 = 0;
                while (n2 < this.conjectures.size()) {
                    Conjecture conjecture = (Conjecture)this.conjectures.elementAt(n2);
                    conjecture.recalc();
                    if (!((PGBoolean)conjecture.output[0]).bool.b) {
                        this.conjectures.removeElement(conjecture);
                        --n2;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.register.copy(2, 0);
        this.register.recall(1);
        this.updateReality(this.algs);
        this.change = true;
        int n3 = 0;
        while (n3 < this.conjectures.size()) {
            Conjecture conjecture = (Conjecture)this.conjectures.elementAt(n3);
            if (!conjecture.sure) {
                this.conjectures.removeElement(conjecture);
                this.fireProverEvent(new ProverEvent(this, conjecture));
                --n3;
            }
            ++n3;
        }
        this.kernel.f17.setCursorDefault();
        return this.conjectures.size() != 0;
    }

    public final boolean createEqualityConjectures(PGElement pGElement) {
        boolean bl = false;
        this.conjectures.removeAllElements();
        int n = 0;
        while (n < this.algs.size()) {
            Algorithm algorithm = (Algorithm)this.algs.elementAt(n);
            if (algorithm != pGElement.f9) {
                int n2 = 0;
                while (n2 < algorithm.output.length) {
                    PGElement pGElement2 = algorithm.output[n2];
                    if (pGElement2.almostEquals(pGElement) && pGElement2 != pGElement) {
                        ConjectureEquals conjectureEquals = new ConjectureEquals();
                        PGVector pGVector = new PGVector();
                        pGVector.addElement(pGElement2);
                        pGVector.addElement(pGElement);
                        conjectureEquals.createInput(pGVector);
                        conjectureEquals.createOutput();
                        this.conjectures.addElement(conjectureEquals);
                        bl = true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }

    public final boolean createIncidenceConjectures(PGElement pGElement) {
        boolean bl = false;
        int n = 0;
        while (n < this.algs.size()) {
            Algorithm algorithm = (Algorithm)this.algs.elementAt(n);
            int n2 = 0;
            while (n2 < algorithm.output.length) {
                PGElement pGElement2 = algorithm.output[n2];
                if (pGElement2.almostIncident(pGElement) && pGElement2 != pGElement && this.pgelements.contains(pGElement2)) {
                    ConjectureIncident conjectureIncident = new ConjectureIncident();
                    PGVector pGVector = new PGVector();
                    pGVector.addElement(pGElement2);
                    pGVector.addElement(pGElement);
                    conjectureIncident.createInput(pGVector);
                    conjectureIncident.createOutput();
                    this.conjectures.addElement(conjectureIncident);
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    public final void createIncidencesFromConjectures() {
        int n = 0;
        while (n < this.conjectures.size()) {
            PGElement pGElement = ((ConjectureIncident)this.conjectures.elementAt((int)n)).input[0];
            PGElement pGElement2 = ((ConjectureIncident)this.conjectures.elementAt((int)n)).input[1];
            if (!pGElement.f7.contains(pGElement2)) {
                pGElement.f7.addElement(pGElement2);
            }
            if (!pGElement2.f7.contains(pGElement)) {
                pGElement2.f7.addElement(pGElement);
            }
            ++n;
        }
        this.conjectures.removeAllElements();
    }

    public final void reportExpectations(PGElement pGElement) {
        int n = 0;
        while (n < this.conjectures.size()) {
            Conjecture conjecture = (Conjecture)this.conjectures.elementAt(n);
            if (!this.expected.removeElement(conjecture)) {
                this.interesting.addElement(conjecture);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.expected.size()) {
            this.fireProverEvent(new ProverEvent(this, (Conjecture)this.expected.elementAt(n2)));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.interesting.size()) {
            this.fireProverEvent(new ProverEvent(this, (Conjecture)this.interesting.elementAt(n3)));
            ++n3;
        }
    }

    public final PGElement getElement(String string) {
        return (PGElement)this.elementhash.get(string);
    }

    public final boolean changeLabel(PGElement pGElement, String string) {
        if (this.elementhash.get(string) != null) {
            return false;
        }
        this.elementhash.remove(pGElement.f8);
        pGElement.f8 = string;
        this.elementhash.put(string, pGElement);
        this.reparseTexts(pGElement);
        if (this.kernel.f24 != null) {
            this.kernel.f24.f178.labelChange(pGElement);
        }
        return true;
    }

    public final void reparseTexts(PGElement pGElement) {
        int n = 0;
        while (n < this.texts.size()) {
            Text text = (Text)this.texts.elementAt(n);
            Enumeration enumeration = this.programs.keys();
            while (enumeration.hasMoreElements()) {
                Algorithm algorithm = (Algorithm)enumeration.nextElement();
                Vector vector = (Vector)this.programs.get(algorithm);
                vector.removeElement(text);
            }
            text.m56(text.m57());
            this.clearMarks();
            this.insertAlgorithmInMovables(text, text);
            text.recalc();
            text.changed = -1;
            ++n;
        }
    }

    public final PGElement addElementNoProof(PGElement pGElement) {
        this.prover = false;
        PGElement pGElement2 = this.addElement(pGElement);
        this.prover = true;
        return pGElement2;
    }

    public final PGElement addElement(PGElement pGElement) {
        Algorithm algorithm = pGElement.f9;
        if (this.pgelements.contains(pGElement)) {
            System.err.println("Internal error: " + pGElement + " added again");
            return pGElement;
        }
        this.hasChanged = true;
        this.pgelements.addElement(pGElement);
        if (pGElement.f8 == null) {
            pGElement.f8 = this.newLabel(pGElement);
        } else if (this.elementhash.get(pGElement.f8) != null) {
            System.err.println("Internal error. Label " + pGElement.f8 + " of new Element");
        }
        this.elementhash.put(pGElement.f8, pGElement);
        if (pGElement instanceof PGText) {
            this.texts.addElement(algorithm);
            algorithm.setProgram(this);
            this.algs.addElement(algorithm);
            this.reparseTexts(pGElement);
            return pGElement;
        }
        if (!this.algs.contains(algorithm)) {
            algorithm.setProgram(this);
            this.algs.addElement(algorithm);
            if (algorithm instanceof Movable) {
                this.programs.put(algorithm, new Vector());
                this.tracingprograms.put(algorithm, new Vector());
            }
            algorithm.register();
            this.clearMarks();
            this.insertAlgorithmInMovables(algorithm, algorithm);
            if (algorithm.needsTrace() != 0) {
                this.clearMarks();
                this.markInput(algorithm);
                this.createTracings(algorithm);
            }
        }
        if (this.prover && this.createEqualityConjectures(pGElement) && this.checkConjectures(pGElement)) {
            PGElement pGElement2;
            Conjecture conjecture = (Conjecture)this.conjectures.elementAt(0);
            if (this.verbose) {
                this.fireProverEvent(new ProverEvent(this, conjecture));
            }
            if ((pGElement2 = conjecture.input[0]) == pGElement) {
                pGElement2 = conjecture.input[1];
            }
            this.deleteElement(pGElement);
            if (pGElement2.f8 == null) {
                this.pgelements.addElement(pGElement2);
                pGElement2.f8 = this.newLabel(pGElement2);
                this.elementhash.put(pGElement2.f8, pGElement2);
            }
            this.conjectures.removeAllElements();
            this.createIncidenceConjectures(pGElement2);
            if (this.checkConjectures(pGElement2)) {
                this.createIncidencesFromConjectures();
            }
            this.recalcLociNoChange();
            this.reparseTexts(pGElement2);
            return pGElement2;
        }
        if (this.kernel.f26 && pGElement instanceof PGFlat) {
            PGFlat pGFlat = (PGFlat)pGElement;
            int n = 0;
            while (n < this.pgelements.size() - 1) {
                PGElement pGElement3 = (PGElement)this.pgelements.elementAt(n);
                if (!pGElement3.f3 && pGElement3.f9 instanceof Movable && ((Movable)((Object)pGElement3.f9)).guessEqual(pGFlat.f9)) {
                    Vec vec = new Vec();
                    Vec vec2 = new Vec();
                    pGFlat.f127.normalizeZ();
                    int n2 = 10;
                    while (n2 > 0) {
                        vec.assign(((PGFlat)pGElement3).f127).normalizeZ().mul(n2);
                        vec2.assign(pGFlat.f127).mul(10 - n2);
                        vec.add(vec2);
                        ((Movable)((Object)pGElement3.f9)).initMove(pGElement3, vec);
                        this.kernel.m16((Movable)((Object)pGElement3.f9));
                        --n2;
                    }
                    return pGElement3;
                }
                ++n;
            }
        }
        if (this.prover) {
            if (this.verbose) {
                this.createExpectations(pGElement);
            }
            this.createIncidenceConjectures(pGElement);
            this.checkConjectures(pGElement);
            if (this.verbose) {
                this.reportExpectations(pGElement);
            }
            this.createIncidencesFromConjectures();
        }
        this.recalcLociNoChange();
        this.reparseTexts(pGElement);
        return pGElement;
    }

    public final void addProverListener(ProverListener proverListener) {
        this.listeners.addElement(proverListener);
    }

    public final void removeProverListener(ProverListener proverListener) {
        this.listeners.removeElement(proverListener);
    }

    private final void fireProverEvent(ProverEvent proverEvent) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((ProverListener)this.listeners.elementAt(n)).info(proverEvent);
                ++n;
            }
            return;
        }
    }

    public final void insertAlgorithmInMovables(Algorithm algorithm, Algorithm algorithm2) {
        if (!algorithm.mark) {
            algorithm.mark = true;
            PGElement[] pGElementArray = algorithm.input;
            Vector vector = (Vector)this.programs.get(algorithm);
            if (vector != null && !vector.contains(algorithm2)) {
                vector.addElement(algorithm2);
            }
            int n = 0;
            while (n < pGElementArray.length) {
                this.insertAlgorithmInMovables(pGElementArray[n].f9, algorithm2);
                ++n;
            }
        }
    }

    public final void clearMarks() {
        int n = this.algs.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)this.algs.elementAt(n2);
            algorithm.mark = false;
            algorithm.done = false;
            ++n2;
        }
    }

    public final void markInput(Algorithm algorithm) {
        if (!algorithm.mark) {
            algorithm.mark = true;
            PGElement[] pGElementArray = algorithm.input;
            int n = 0;
            while (n < pGElementArray.length) {
                this.markInput(pGElementArray[n].f9);
                ++n;
            }
        }
    }

    public final boolean inputMarked(Algorithm algorithm) {
        PGElement[] pGElementArray = algorithm.input;
        int n = 0;
        while (n < pGElementArray.length) {
            if (pGElementArray[n].f9.mark) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final void markOutputFromMark() {
        int n = 0;
        while (n < this.algs.size()) {
            Algorithm algorithm = (Algorithm)this.algs.elementAt(n);
            if (this.inputMarked(algorithm)) {
                algorithm.mark = true;
            }
            ++n;
        }
    }

    public final void createTracings(Algorithm algorithm) {
        if (algorithm.done) {
            return;
        }
        algorithm.done = true;
        PGElement[] pGElementArray = algorithm.input;
        if (algorithm instanceof Movable) {
            Vector<Algorithm> vector = new Vector<Algorithm>();
            Vector vector2 = (Vector)this.programs.get(algorithm);
            Vector vector3 = (Vector)this.tracingprograms.get(algorithm);
            boolean bl = false;
            int n = 0;
            while (n < vector2.size()) {
                Algorithm algorithm2 = (Algorithm)vector2.elementAt(n);
                if (vector3.contains(algorithm2) || algorithm2.mark) {
                    vector.addElement(algorithm2);
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                this.tracingprograms.remove(algorithm);
                this.tracingprograms.put(algorithm, vector);
            }
        }
        int n = 0;
        while (n < pGElementArray.length) {
            this.createTracings(pGElementArray[n].f9);
            ++n;
        }
    }

    public final void addTmpElement(PGElement pGElement) {
        this.tmpPGElements.addElement(pGElement);
        this.tmpAlgs.addElement(pGElement.f9);
    }

    public final void clearTmp() {
        this.tmpAlgs.removeAllElements();
        this.tmpPGElements.removeAllElements();
    }

    public final void updateReality() {
        this.updateReality(this.algs);
    }

    public final void updateReality(Vector vector) {
        int n = vector.size();
        this.real = true;
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < algorithm.output.length) {
                this.real &= algorithm.output[n3].updateReality();
                ++n3;
            }
            ++n2;
        }
    }

    public final String newLabel(PGElement pGElement) {
        String string = null;
        if (pGElement instanceof PGPoint) {
            int n = 0;
            while (this.elementhash.get(string = n < 26 ? String.valueOf((char)(n + 65)) : "P" + (n - 26)) != null) {
                n += n == 7 ? 3 : 1;
            }
            return string;
        }
        if (pGElement instanceof PGLine) {
            int n = 0;
            while (this.elementhash.get(string = n < 26 ? String.valueOf((char)(n + 97)) : "l" + (n - 26)) != null) {
                n += n == 7 ? 3 : 1;
            }
            return string;
        }
        if (pGElement instanceof PGConic) {
            int n = 0;
            while (this.elementhash.get(string = "C" + n) != null) {
                ++n;
            }
            return string;
        }
        if (pGElement instanceof PGPolygon) {
            int n = 0;
            while (this.elementhash.get(string = "Poly" + n) != null) {
                ++n;
            }
            return string;
        }
        if (pGElement instanceof PGSegment) {
            int n = 0;
            while (this.elementhash.get(string = "S" + n) != null) {
                ++n;
            }
            return string;
        }
        if (pGElement instanceof PGText) {
            int n = 0;
            while (this.elementhash.get(string = "Text" + n) != null) {
                ++n;
            }
            return string;
        }
        if (pGElement instanceof PGAngle) {
            int n = 0;
            while (this.elementhash.get(string = "alpha" + n) != null) {
                ++n;
            }
            return string;
        }
        if (pGElement instanceof PGDistance) {
            int n = 0;
            while (this.elementhash.get(string = "dist" + n) != null) {
                ++n;
            }
            return string;
        }
        int n = 0;
        while (this.elementhash.get(string = "E" + n) != null) {
            ++n;
        }
        return string;
    }

    public final void write(PrintWriter printWriter) {
        Object object;
        Object object2 = null;
        int n = 0;
        while (n < this.algs.size()) {
            Algorithm algorithm = (Algorithm)this.algs.elementAt(n);
            if (!(algorithm instanceof Text)) {
                object = algorithm.geo;
                if (object != null && object != object2) {
                    ((Geometry)object).write(printWriter);
                    object2 = object;
                }
                algorithm.write(printWriter);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.algs.size()) {
            object = (Algorithm)this.algs.elementAt(n2);
            if (object instanceof Text) {
                ((Algorithm)object).write(printWriter);
            }
            ++n2;
        }
        if (object2 != this.kernel.f16.value) {
            ((Geometry)this.kernel.f16.value).write(printWriter);
        }
    }

    public final void recalcLoci() {
        this.recalcLoci(this.algs);
    }

    public final void recalcLociNoChange() {
        int n = this.algs.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)this.algs.elementAt(n2);
            if (algorithm instanceof Locus) {
                algorithm.recalc();
            }
            ++n2;
        }
    }

    private final void recalcLoci(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Algorithm algorithm = (Algorithm)vector.elementAt(n2);
            if (algorithm instanceof Locus) {
                algorithm.recalc();
                if (this.change) {
                    algorithm.changed = -1;
                }
            }
            ++n2;
        }
    }

    static {
        progressGraphics = null;
    }
}

