/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.LWFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Toolbar
extends Container
implements MouseListener,
MouseMotionListener {
    public boolean collapsed = false;
    public boolean collapsable = true;
    public Dimension prefSize;
    public Component[] components;

    public Toolbar(String string) {
        this.setLayout(new FlowLayout(0, 2, 2));
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.collapsable) {
            this.setCollapsed(!this.collapsed);
            LWFrame lWFrame = (LWFrame)this.getParent();
            lWFrame.callLayout();
        }
    }

    public final void mousePressed(MouseEvent mouseEvent) {
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void setCollapsed(boolean bl) {
        if (this.collapsed != bl) {
            this.collapsed = bl;
            if (this.collapsed) {
                this.components = this.getComponents();
                this.removeAll();
                return;
            }
            int n = 0;
            while (n < this.components.length) {
                this.add(this.components[n]);
                ++n;
            }
            this.components = null;
        }
    }

    public final int height(int n) {
        if (this.collapsed) {
            return 7;
        }
        return this.trueheight(n);
    }

    public final int trueheight(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = ((FlowLayout)this.getLayout()).getVgap();
        int n5 = ((FlowLayout)this.getLayout()).getHgap();
        Insets insets = this.getInsets();
        int n6 = insets.left + insets.right + n5;
        boolean bl = this.components == null;
        if (bl) {
            this.components = this.getComponents();
        }
        int n7 = 0;
        while (n7 < this.components.length) {
            Component component = this.components[n7];
            Dimension dimension = component.getPreferredSize();
            if (n6 + dimension.width > n) {
                n6 = insets.left + insets.right + n5;
                n2 += n3 + n4;
                n3 = 0;
            }
            n6 += dimension.width + n5;
            n3 = Math.max(n3, dimension.height);
            ++n7;
        }
        n2 += n3 + insets.top + insets.bottom + 2 * n4;
        if (bl) {
            this.components = null;
        }
        return n2;
    }

    public final void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        Color color = this.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.draw3DRect(0, 0, dimension.width, dimension.height, true);
        if (!this.collapsed) {
            super.paint(graphics);
            return;
        }
        int n3 = this.trueheight(n2);
        graphics.draw3DRect(0, 0, n3, 6, false);
        graphics.setColor(color.brighter());
        int n4 = 1;
        while (n4 < 6) {
            n = (n4 + 2) % 4;
            while (n < n3) {
                graphics.drawLine(n, n4, n, n4);
                n += 4;
            }
            n4 += 2;
        }
        graphics.setColor(color.darker());
        n = 2;
        while (n < 6) {
            int n5 = (n + 2) % 4;
            while (n5 < n3) {
                graphics.drawLine(n5, n, n5, n);
                n5 += 4;
            }
            n += 2;
        }
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public final Dimension getPreferredSize() {
        return this.prefSize;
    }
}

