/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.Intl;
import de.cinderella.controls.ObservableInt;
import de.cinderella.controls.Preferences;
import de.cinderella.controls.ToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;

public class ImageSlider
extends Component
implements MouseListener,
MouseMotionListener,
Observer {
    public Dimension d = new Dimension();
    public ObservableInt value;
    public String ttt;
    public Point pos;
    public Color col;
    public int max;
    public int min;
    public int inset;
    public int step;
    public boolean ticks = false;

    public ImageSlider(ObservableInt observableInt) {
        observableInt.addObserver(this);
        this.value = observableInt;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setParameter(100, 15, Color.green);
        this.min = 0;
        this.max = 1000;
        this.inset = 0;
        try {
            this.ttt = Intl.tooltips.getString(observableInt.myID);
            return;
        }
        catch (Exception exception) {
            System.err.println("NTTF " + observableInt.myID);
            return;
        }
    }

    public final void setParameter(int n, int n2, Color color) {
        int n3 = Preferences.getInt("cinderella.imageslider.scale", Preferences.getInt("cinderella.imagebutton.scale", 1));
        this.d.width = n * n3;
        this.d.height = n2 * n3;
        this.col = color;
        if (this.col == null) {
            this.col = new Color(152, 152, 152);
        }
    }

    public final Dimension getPreferredSize() {
        return this.d;
    }

    public final void setColor(Color color) {
        this.col = color;
        if (this.col == null) {
            this.col = new Color(152, 152, 152);
        }
    }

    public final void setMin(int n) {
        if (n <= this.value.value) {
            this.min = n;
            this.repaint();
        }
    }

    public final void setMax(int n) {
        if (n >= this.value.value) {
            this.max = n;
            this.repaint();
        }
    }

    public final void setTicks(boolean bl, int n, int n2) {
        this.ticks = bl;
        this.step = n;
        this.inset = n2;
        this.repaint();
    }

    public final void setTicks(boolean bl) {
        if (bl) {
            this.setTicks(bl, 1, 10);
            return;
        }
        this.setTicks(bl, 0, 0);
    }

    public final void drawTicks(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.col.darker().darker().darker());
        int n4 = this.min;
        while (n4 <= this.max) {
            double d = ((double)n4 - (double)this.min) / (double)(this.max - this.min);
            int n5 = (int)(d * (double)n3) + 2 + this.inset;
            graphics.drawLine(n5, 2, n5, n2 - 3);
            n4 += this.step;
        }
    }

    public final void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = dimension.width;
        double d = ((double)this.value.value - (double)this.min) / (double)(this.max - this.min);
        int n3 = n2 - 5 - 2 * this.inset;
        int n4 = (int)(d * (double)n3) + 2 + this.inset;
        graphics.setColor(this.col);
        graphics.fillRect(2, 2, n2 - 4, n - 4);
        if (this.ticks) {
            this.drawTicks(graphics, n2, n, n3);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(n4 - 1, 2, 2, n - 3);
        graphics.setColor(Color.white);
        graphics.drawLine(n4, 2, n4, n - 3);
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(0, 0, n2 - 1, n - 1, false);
        graphics.draw3DRect(1, 1, n2 - 3, n - 3, true);
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void update(Observable observable, Object object) {
        this.repaint();
    }

    public void mouseAction(MouseEvent mouseEvent) {
        ToolTip.stopTimer();
        int n = mouseEvent.getX() - 2 - this.inset;
        double d = (double)n / (double)(this.getSize().width - 5 - 2 * this.inset);
        int n2 = (int)(d * (double)(this.max - this.min) + 0.5 + (double)this.min);
        this.value.setValue(Math.min(Math.max(n2, this.min), this.max));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseAction(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseAction(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseAction(mouseEvent);
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        ToolTip.setPos(this.getPos());
        ToolTip.setText(this.ttt);
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        ToolTip.resetTimer();
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        ToolTip.setText(null);
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        ToolTip.resetTimer();
    }

    public final Point getPos() {
        this.pos = this.getLocationOnScreen();
        this.pos.x += this.getSize().width * 3 / 4;
        this.pos.y += this.getSize().height + 10;
        return this.pos;
    }
}

