/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import antlr.ANTLRException;
import antlr.CharScanner;
import antlr.Parser;
import de.cinderella.Cindy;
import de.cinderella.controls.Intl;
import de.cinderella.controls.MessageDialog;
import de.cinderella.controls.Preferences;
import de.cinderella.controls.ResourceImage;
import de.cinderella.geometry.Program;
import java.awt.FileDialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileOps {
    public static String defaultDirectory = Preferences.getString("cinderella.defaultDir");
    public static String defaultLoadFile = "*.cdy";
    public static String defaultSaveFile = Intl.getMessage("defaultFileName");

    public static int saveBefore(String string, Cindy cindy) {
        if (cindy.f15.hasChanged) {
            int n = MessageDialog.show3ButtonDialog(String.valueOf(string) + "SaveBeforeTitle", String.valueOf(string) + "SaveBeforeMsg", String.valueOf(string) + "DontSave", String.valueOf(string) + "Cancel", String.valueOf(string) + "Save");
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return FileOps.save(cindy);
                }
            }
        }
        return 1;
    }

    public static File showLoadDialog(String string) {
        return FileOps.showLoadDialog(string, string);
    }

    public static File showLoadDialog() {
        return FileOps.showLoadDialog(".cdy");
    }

    public static File showLoadDialog(String string, String string2) {
        FileDialog fileDialog = new FileDialog(ResourceImage.frame, Intl.getMessage("loadDialogTitle" + string), 0);
        fileDialog.setFile(defaultLoadFile);
        fileDialog.setDirectory(defaultDirectory);
        fileDialog.pack();
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            if (file.exists()) {
                return file;
            }
            String string3 = String.valueOf(fileDialog.getFile()) + string;
            file = new File(fileDialog.getDirectory(), string3);
            if (file.exists()) {
                return file;
            }
            string3 = String.valueOf(fileDialog.getFile()) + string2;
            file = new File(fileDialog.getDirectory(), string3);
            if (file.exists()) {
                return file;
            }
            FileOps.error("load", new FileNotFoundException(), file);
        }
        return null;
    }

    public static File showSaveDialog() {
        return FileOps.showSaveDialog(".cdy");
    }

    public static File showSaveDialog(String string) {
        return FileOps.showSaveDialog(string, string);
    }

    public static String rewrite(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        string = String.valueOf(string) + string2;
        return string;
    }

    public static File showSaveDialog(String string, String string2) {
        FileDialog fileDialog = new FileDialog(ResourceImage.frame, Intl.getMessage("saveDialogTitle" + string), 1);
        fileDialog.setFile(FileOps.rewrite(defaultSaveFile, string));
        fileDialog.setDirectory(defaultDirectory);
        fileDialog.pack();
        fileDialog.show();
        if (fileDialog.getFile() != null && !fileDialog.getFile().equals("")) {
            String string3 = fileDialog.getFile();
            if (!string3.endsWith(string) && !string3.endsWith(string2)) {
                string3 = String.valueOf(string3) + string;
            }
            return new File(fileDialog.getDirectory(), string3);
        }
        return null;
    }

    public static int load(Cindy cindy, File file) {
        Parser parser;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(fileInputStream)));
            cindy.f15.clear();
            cindy.f23.clear();
            cindy.f17.reset();
            CharScanner charScanner = new CharScanner(bufferedReader);
            parser = new Parser(charScanner);
        }
        catch (Exception exception) {
            cindy.f15.clear();
            return FileOps.error("load", exception, file);
        }
        try {
            parser.de_cinderella_parser_CindyParser__JAX__kernel = cindy;
            parser.construction();
        }
        catch (IOException iOException) {
            cindy.f15.clear();
            return FileOps.error("load", iOException, file);
        }
        catch (ANTLRException aNTLRException) {
            cindy.f15.clear();
            return FileOps.error("Parse", aNTLRException, file);
        }
        cindy.f15.recalcLociNoChange();
        cindy.f15.directory = file.getParent();
        cindy.f15.filename = file.getName();
        cindy.f15.setKernel(cindy);
        defaultDirectory = file.getParent();
        cindy.f15.hasChanged = false;
        cindy.f17.setTitle(cindy.f15.filename);
        cindy.f17.sendProgram();
        cindy.f17.redrawLater();
        return 1;
    }

    public static String filemessage(String string, String string2, File file) {
        String string3;
        try {
            string3 = Intl.messages.getString(string);
        }
        catch (Exception exception) {
            try {
                string3 = Intl.messages.getString(string2);
            }
            catch (Exception exception2) {
                return string;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " .,!?()[]\"{}:;-+", true);
        StringBuffer stringBuffer = new StringBuffer(string3.length() + 20);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("$FILE")) {
                string4 = file.getName();
            } else if (string4.equals("$FILEABS")) {
                string4 = file.getAbsolutePath();
            }
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public static int save(Cindy cindy) {
        Program program = cindy.f15;
        File file = null;
        if (program.filename != null && program.directory != null) {
            file = new File(program.directory, program.filename);
        }
        if (file != null && file.exists()) {
            return FileOps.save(cindy, file);
        }
        file = FileOps.showSaveDialog();
        if (file == null) {
            return 0;
        }
        return FileOps.save(cindy, file);
    }

    public static int saveIfChanged(Cindy cindy) {
        return FileOps.save(cindy);
    }

    public static int save(Cindy cindy, File file) {
        Program program = cindy.f15;
        program.filename = file.getName();
        program.directory = file.getParent();
        try {
            InetAddress inetAddress;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new GZIPOutputStream(fileOutputStream));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
            printWriter.println("//Cindy-1.0");
            printWriter.println("//Created on: " + DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())));
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
            }
            printWriter.println("//For: " + System.getProperty("user.name") + "@" + inetAddress);
            printWriter.println("//DO NOT EDIT --- MACHINE GENERATED CODE");
            program.write(printWriter);
            if (cindy.f24 != null) {
                printWriter.println("//");
                printWriter.println("//Exercise Information");
                cindy.f24.m69(printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            return FileOps.error("save", exception, file);
        }
        program.hasChanged = false;
        if (!Preferences.getBoolean("cinderella.quiet")) {
            MessageDialog.showMessageNoIntl(FileOps.filemessage("savesuccessTitle", "", file), FileOps.filemessage("savesuccessMsg", "", file));
        }
        defaultSaveFile = file.getName();
        defaultDirectory = file.getParent();
        return 1;
    }

    public static int writeHTML(Cindy cindy, File file) {
        Program program = cindy.f15;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.println("<HTML>");
            printWriter.println("<HEAD>");
            printWriter.println("<TITLE> " + program.filename + " </TITLE>");
            program.user = System.getProperty("user.name");
            printWriter.println("<META author = \"" + program.user + " (autogenerated by cinderella)\">");
            printWriter.println("<META keywords = \"cinderella export\">");
            printWriter.println("</HEAD>");
            printWriter.println("<BODY>");
            String cfr_ignored_0 = String.valueOf(System.getProperty("os.name")) + "-" + System.getProperty("os.version") + "-" + System.getProperty("os.arch");
            printWriter.println("<! $Revision: 1.76 $ on " + System.getProperty("os.name") + "-" + System.getProperty("os.version") + "-" + System.getProperty("os.arch") + ">");
            cindy.f17.toHTML(printWriter);
            if (cindy.f26) {
                printWriter.println("<applet code     = \"de.cinderella.CindyApplet\"");
                printWriter.println("        archive = \"cindyrun.jar\"");
                printWriter.println("        width    = " + 300);
                printWriter.println("        height   = " + 100 + ">");
                printWriter.println("<param  name=console value=\"de.cinderella.ports.ExerciseConsole\">");
                printWriter.println("<param  name=kernelID value=\"" + cindy.f27 + "\">");
                printWriter.println("<param  name=exercise value=\"true\">");
                printWriter.println("<param  name=filename value=\"" + program.filename + "\">");
                printWriter.println(Intl.getMessage("enableJava"));
                printWriter.println("</applet>");
                printWriter.println("<applet code     = \"de.cinderella.CindyApplet\"");
                printWriter.println("        archive = \"cindyrun.jar\"");
                printWriter.println("        width    = " + 300);
                printWriter.println("        height   = " + 100 + ">");
                printWriter.println("<param  name=kernelID value=\"" + cindy.f27 + "\">");
                printWriter.println("<param  name=exercise value=\"true\">");
                printWriter.println("<param  name=controls value=\"de.cinderella.ports.CustomControl\">");
                printWriter.println("<param  name=filename value=\"" + program.filename + "\">");
                printWriter.println(Intl.getMessage("enableJava"));
                printWriter.println("</applet>");
            }
            printWriter.println("<hr>");
            printWriter.println("<p>Created with <a href=\"http://www.cinderella.de\">Cinderella</a></p>");
            printWriter.println("</BODY>");
            printWriter.flush();
            printWriter.close();
            if (!Preferences.getBoolean("cinderella.quiet")) {
                MessageDialog.showMessageNoIntl(FileOps.filemessage("exportsuccessTitle", "", file), FileOps.filemessage("exportsuccessMsg", "", file));
            }
        }
        catch (Exception exception) {
            return FileOps.error("saveHTML", exception, file);
        }
        return 1;
    }

    public static int error(String string, Exception exception, File file) {
        String string2 = String.valueOf(string) + "." + exception.getClass().getName();
        MessageDialog.showMessageNoIntl(FileOps.filemessage(String.valueOf(string2) + "Title", String.valueOf(string) + "Title", file), FileOps.filemessage(String.valueOf(string2) + "Msg", String.valueOf(string) + "Msg", file));
        return 3;
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"", true);
        stringBuffer.append("\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\"")) {
                stringBuffer.append("\\\"");
                continue;
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }
}

