/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.MixColor;
import de.cinderella.controls.Preferences;
import java.awt.Color;
import java.io.Serializable;
import java.util.Observable;

public final class ColorTable
extends Observable
implements Serializable {
    public static final Color[] bright = new Color[]{Preferences.getColor("cinderella.color.bright.1", Color.white), Preferences.getColor("cinderella.color.bright.2", Color.black), Preferences.getColor("cinderella.color.bright.3", Color.red), Preferences.getColor("cinderella.color.bright.4", Color.blue), Preferences.getColor("cinderella.color.bright.5", Color.green), Preferences.getColor("cinderella.color.bright.6", Color.yellow), Preferences.getColor("cinderella.color.bright.7", Color.pink), Preferences.getColor("cinderella.color.bright.8", Color.cyan), Preferences.getColor("cinderella.color.bright.9", Color.orange), Preferences.getColor("cinderella.color.bright.10", new Color(25, 158, 78)), Preferences.getColor("cinderella.color.bright.11", new Color(183, 85, 0)), Preferences.getColor("cinderella.color.bright.12", new Color(119, 0, 183)), Preferences.getColor("cinderella.color.bright.13", new Color(255, 127, 0)), Preferences.getColor("cinderella.color.bright.14", new Color(3, 167, 188)), Preferences.getColor("cinderella.color.bright.15", new Color(193, 0, 0)), Preferences.getColor("cinderella.color.bright.16", Color.gray)};
    public static final Color[] pastell = new Color[]{Preferences.getColor("cinderella.color.pastell.1", Color.white), Preferences.getColor("cinderella.color.pastell.2", Color.black), Preferences.getColor("cinderella.color.pastell.3", Color.red), Preferences.getColor("cinderella.color.pastell.4", Color.blue), Preferences.getColor("cinderella.color.pastell.5", Color.green), Preferences.getColor("cinderella.color.pastell.6", Color.yellow), Preferences.getColor("cinderella.color.pastell.7", Color.pink), Preferences.getColor("cinderella.color.pastell.8", Color.cyan), Preferences.getColor("cinderella.color.pastell.9", Color.orange), Preferences.getColor("cinderella.color.pastell.10", Color.gray), Preferences.getColor("cinderella.color.pastell.11", new Color(255, 74, 74)), Preferences.getColor("cinderella.color.pastell.12", new Color(250, 255, 158)), Preferences.getColor("cinderella.color.pastell.13", new Color(182, 255, 170)), Preferences.getColor("cinderella.color.pastell.14", new Color(130, 242, 255)), Preferences.getColor("cinderella.color.pastell.15", new Color(212, 163, 255)), Preferences.getColor("cinderella.color.pastell.16", new Color(255, 189, 119))};
    public MixColor[] table = new MixColor[19];
    public MixColor background = new MixColor(Preferences.getColor("cinderella.defaults.background", new Color(168, 176, 192)));
    public MixColor black = new MixColor(Preferences.getColor("cinderella.defaults.black", Color.black), this.background);
    public MixColor highlight = new MixColor(Preferences.getColor("cinderella.defaults.highlight", Color.white), this.background);
    public static int BRIGHT = 1;
    public static int PASTELL = 2;

    public ColorTable(int n) {
        int n2 = 0;
        while (n2 < 16) {
            this.table[n2] = new MixColor(n == BRIGHT ? bright[n2] : pastell[n2], this.background);
            ++n2;
        }
        this.table[18] = this.background;
        this.table[17] = this.black;
        this.table[16] = this.highlight;
    }

    private final void updateColors() {
        int n = 0;
        while (n < 18) {
            this.table[n] = new MixColor(this.table[n].full, this.background);
            ++n;
        }
        this.black = this.table[17];
        this.highlight = this.table[16];
    }

    public final int highlightIndex() {
        return 16;
    }

    public final boolean isBackIndex(int n) {
        return n == 18;
    }

    public final boolean isBlackIndex(int n) {
        return n == 17;
    }

    public final boolean isHighlightIndex(int n) {
        return n == 16;
    }

    public final void setBackground(Color color) {
        this.table[18] = new MixColor(color);
        this.background = this.table[18];
        this.updateColors();
    }

    public final void setHighlight(Color color) {
        this.table[16] = new MixColor(color, this.background);
        this.highlight = this.table[16];
    }

    public final void setBlack(Color color) {
        this.table[17] = new MixColor(color, this.background);
        this.black = this.table[17];
    }

    public final void setColorAt(int n, Color color) {
        if (!this.table[n].full.equals(color)) {
            this.table[n] = new MixColor(color, this.background);
            switch (n) {
                case 17: {
                    this.black = this.table[17];
                }
                case 16: {
                    this.highlight = this.table[16];
                }
                case 18: {
                    this.background = this.table[18];
                    this.updateColors();
                }
            }
            this.setChanged();
            this.notifyObservers(new Integer(n));
        }
    }
}

